/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial.rtree;

import com.facebook.presto.common.array.DoubleBigArray;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.geospatial.rtree.HasExtent;
import com.facebook.presto.geospatial.rtree.HilbertIndex;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import org.openjdk.jol.info.ClassLayout;

public class Flatbush<T extends HasExtent> {
    @VisibleForTesting
    static final int ENVELOPE_SIZE = 4;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Flatbush.class).instanceSize();
    private static final int DEFAULT_DEGREE = 16;
    private final int degree;
    private final int[] levelOffsets;
    private final DoubleBigArray tree;
    private final T[] items;

    public Flatbush(T[] items, int degree) {
        Preconditions.checkArgument((degree > 0 ? 1 : 0) != 0, (Object)"degree must be positive");
        this.degree = degree;
        this.items = (HasExtent[])Objects.requireNonNull(items, "items is null");
        this.levelOffsets = Flatbush.calculateLevelOffsets(items.length, degree);
        this.tree = this.buildTree();
    }

    public Flatbush(T[] items) {
        this((HasExtent[])items, 16);
    }

    private static int[] calculateLevelOffsets(int numItems, int degree) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        offsets.add(0);
        int level = 0;
        while (numItems > 1) {
            int numChildren = (int)Math.ceil(1.0 * (double)numItems / (double)degree) * degree;
            offsets.add((Integer)offsets.get(level) + 4 * numChildren);
            numItems = numChildren / degree;
            ++level;
        }
        return offsets.stream().mapToInt(Integer::intValue).toArray();
    }

    private DoubleBigArray buildTree() {
        DoubleBigArray tree = new DoubleBigArray(Double.NaN);
        tree.ensureCapacity((long)(this.levelOffsets[this.levelOffsets.length - 1] + 4));
        if (this.items.length > this.degree) {
            this.sortByHilbertIndex((HasExtent[])this.items);
        }
        int writeOffset = 0;
        for (T item : this.items) {
            tree.set((long)writeOffset++, item.getExtent().getXMin());
            tree.set((long)writeOffset++, item.getExtent().getYMin());
            tree.set((long)writeOffset++, item.getExtent().getXMax());
            tree.set((long)writeOffset++, item.getExtent().getYMax());
        }
        int numChildren = this.items.length;
        for (int level = 0; level < this.levelOffsets.length - 1; ++level) {
            int child;
            int readOffset = this.levelOffsets[level];
            writeOffset = this.levelOffsets[level + 1];
            int numParents = 0;
            double xMin = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (child = 0; child < numChildren; ++child) {
                xMin = Math.min(xMin, tree.get((long)readOffset++));
                yMin = Math.min(yMin, tree.get((long)readOffset++));
                xMax = Math.max(xMax, tree.get((long)readOffset++));
                yMax = Math.max(yMax, tree.get((long)readOffset++));
                if ((child + 1) % this.degree != 0) continue;
                ++numParents;
                tree.set((long)writeOffset++, xMin);
                tree.set((long)writeOffset++, yMin);
                tree.set((long)writeOffset++, xMax);
                tree.set((long)writeOffset++, yMax);
                xMin = Double.POSITIVE_INFINITY;
                yMin = Double.POSITIVE_INFINITY;
                xMax = Double.NEGATIVE_INFINITY;
                yMax = Double.NEGATIVE_INFINITY;
            }
            if (child % this.degree != 0) {
                tree.set((long)writeOffset++, xMin);
                tree.set((long)writeOffset++, yMin);
                tree.set((long)writeOffset++, xMax);
                tree.set((long)writeOffset++, yMax);
            }
            numChildren = ++numParents;
        }
        return tree;
    }

    public void findIntersections(Rectangle query, Consumer<T> consumer) {
        IntArrayList todoNodes = new IntArrayList(this.levelOffsets.length * this.degree);
        IntArrayList todoLevels = new IntArrayList(this.levelOffsets.length * this.degree);
        int rootLevel = this.levelOffsets.length - 1;
        int rootIndex = this.levelOffsets[rootLevel];
        if (this.doesIntersect(query, rootIndex)) {
            todoNodes.push(rootIndex);
            todoLevels.push(rootLevel);
        }
        while (!todoNodes.isEmpty()) {
            int nodeIndex = todoNodes.popInt();
            int level = todoLevels.popInt();
            if (level == 0) {
                consumer.accept(this.items[nodeIndex / 4]);
                continue;
            }
            int childrenOffset = this.getChildrenOffset(nodeIndex, level);
            for (int i = 0; i < this.degree; ++i) {
                int childIndex = childrenOffset + 4 * i;
                if (!this.doesIntersect(query, childIndex)) continue;
                todoNodes.push(childIndex);
                todoLevels.push(level - 1);
            }
        }
    }

    private boolean doesIntersect(Rectangle query, int nodeIndex) {
        return query.getXMax() >= this.tree.get((long)nodeIndex) && query.getYMax() >= this.tree.get((long)(nodeIndex + 1)) && query.getXMin() <= this.tree.get((long)(nodeIndex + 2)) && query.getYMin() <= this.tree.get((long)(nodeIndex + 3));
    }

    @VisibleForTesting
    int getChildrenOffset(int nodeIndex, int level) {
        int indexInLevel = nodeIndex - this.levelOffsets[level];
        return this.levelOffsets[level - 1] + this.degree * indexInLevel;
    }

    @VisibleForTesting
    int getHeight() {
        return this.levelOffsets.length;
    }

    private void sortByHilbertIndex(T[] items) {
        if (items == null || items.length < 2) {
            return;
        }
        Rectangle totalExtent = items[0].getExtent();
        for (int i = 1; i < items.length; ++i) {
            totalExtent = totalExtent.merge(items[i].getExtent());
        }
        HilbertIndex hilbert = new HilbertIndex(totalExtent);
        Arrays.parallelSort(items, Comparator.comparing(item -> hilbert.indexOf((item.getExtent().getXMin() + item.getExtent().getXMax()) / 2.0, (item.getExtent().getYMin() + item.getExtent().getYMax()) / 2.0)));
    }

    public boolean isEmpty() {
        return this.items.length == 0;
    }

    public long getEstimatedSizeInBytes() {
        long result = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.levelOffsets) + this.tree.sizeOf();
        for (T item : this.items) {
            result += item.getEstimatedSizeInBytes();
        }
        return result;
    }
}

