/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import com.facebook.presto.geospatial.GeometryType;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.HashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.IsSimpleOp;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;

public final class GeometryUtils {
    private static final CoordinateSequenceFactory COORDINATE_SEQUENCE_FACTORY = new PackedCoordinateSequenceFactory();
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory(COORDINATE_SEQUENCE_FACTORY);

    private GeometryUtils() {
    }

    private static double translateFromAVNaN(double n) {
        return n < -1.0E38 ? Double.NaN : n;
    }

    public static double translateToAVNaN(double n) {
        return Double.isNaN(n) ? -1.7976931348623157E308 : n;
    }

    public static boolean isEsriNaN(double d) {
        return Double.isNaN(d) || Double.isNaN(GeometryUtils.translateFromAVNaN(d));
    }

    public static int getPointCount(OGCGeometry ogcGeometry) {
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        int points = 0;
        Geometry geometry;
        while ((geometry = cursor.next()) != null) {
            if (geometry.isEmpty()) continue;
            if (geometry instanceof com.esri.core.geometry.Point) {
                ++points;
                continue;
            }
            points += ((MultiVertexGeometry)geometry).getPointCount();
        }
        return points;
    }

    public static Envelope getEnvelope(OGCGeometry ogcGeometry) {
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        Envelope overallEnvelope = new Envelope();
        Geometry geometry;
        while ((geometry = cursor.next()) != null) {
            Envelope envelope = new Envelope();
            geometry.queryEnvelope(envelope);
            overallEnvelope.merge(envelope);
        }
        return overallEnvelope;
    }

    public static Rectangle getExtent(OGCGeometry ogcGeometry) {
        return GeometryUtils.getExtent(ogcGeometry, 0.0);
    }

    public static Rectangle getExtent(OGCGeometry ogcGeometry, double radius) {
        Envelope envelope = GeometryUtils.getEnvelope(ogcGeometry);
        return new Rectangle(envelope.getXMin() - radius, envelope.getYMin() - radius, envelope.getXMax() + radius, envelope.getYMax() + radius);
    }

    public static org.locationtech.jts.geom.Envelope getJtsEnvelope(OGCGeometry ogcGeometry, double radius) {
        Envelope esriEnvelope = GeometryUtils.getEnvelope(ogcGeometry);
        if (esriEnvelope.isEmpty()) {
            return new org.locationtech.jts.geom.Envelope();
        }
        return new org.locationtech.jts.geom.Envelope(esriEnvelope.getXMin() - radius, esriEnvelope.getXMax() + radius, esriEnvelope.getYMin() - radius, esriEnvelope.getYMax() + radius);
    }

    public static org.locationtech.jts.geom.Envelope getJtsEnvelope(OGCGeometry ogcGeometry) {
        return GeometryUtils.getJtsEnvelope(ogcGeometry, 0.0);
    }

    public static boolean disjoint(Envelope envelope, OGCGeometry ogcGeometry) {
        Geometry geometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        do {
            if ((geometry = cursor.next()) != null) continue;
            return true;
        } while (GeometryEngine.disjoint((Geometry)geometry, (Geometry)envelope, null));
        return false;
    }

    public static boolean contains(OGCGeometry ogcGeometry, Envelope envelope) {
        Geometry geometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        do {
            if ((geometry = cursor.next()) != null) continue;
            return false;
        } while (!GeometryEngine.contains((Geometry)geometry, (Geometry)envelope, null));
        return true;
    }

    public static boolean isPointOrRectangle(OGCGeometry ogcGeometry, Envelope envelope) {
        if (ogcGeometry instanceof OGCPoint) {
            return true;
        }
        if (!(ogcGeometry instanceof OGCPolygon)) {
            return false;
        }
        Polygon polygon = (Polygon)ogcGeometry.getEsriGeometry();
        if (polygon.getPathCount() > 1) {
            return false;
        }
        if (polygon.getPointCount() != 4) {
            return false;
        }
        HashSet<com.esri.core.geometry.Point> corners = new HashSet<com.esri.core.geometry.Point>();
        corners.add(new com.esri.core.geometry.Point(envelope.getXMin(), envelope.getYMin()));
        corners.add(new com.esri.core.geometry.Point(envelope.getXMin(), envelope.getYMax()));
        corners.add(new com.esri.core.geometry.Point(envelope.getXMax(), envelope.getYMin()));
        corners.add(new com.esri.core.geometry.Point(envelope.getXMax(), envelope.getYMax()));
        for (int i = 0; i < 4; ++i) {
            com.esri.core.geometry.Point point = polygon.getPoint(i);
            if (corners.contains(point)) continue;
            return false;
        }
        return true;
    }

    public static org.locationtech.jts.geom.Geometry jtsGeometryFromWkt(String wkt) {
        try {
            return new WKTReader(GEOMETRY_FACTORY).read(wkt);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid WKT: " + e.getMessage(), e);
        }
    }

    public static String wktFromJtsGeometry(org.locationtech.jts.geom.Geometry geometry) {
        return new WKTWriter().write(geometry);
    }

    public static Point createJtsEmptyPoint() {
        return GEOMETRY_FACTORY.createPoint();
    }

    public static Point createJtsPoint(Coordinate coordinate) {
        return GEOMETRY_FACTORY.createPoint(coordinate);
    }

    public static Point createJtsPoint(double x, double y) {
        return GeometryUtils.createJtsPoint(new Coordinate(x, y));
    }

    public static MultiPoint createJtsMultiPoint(CoordinateSequence coordinates) {
        return GEOMETRY_FACTORY.createMultiPoint(coordinates);
    }

    public static org.locationtech.jts.geom.Geometry createJtsEmptyLineString() {
        return GEOMETRY_FACTORY.createLineString();
    }

    public static org.locationtech.jts.geom.Geometry createJtsLineString(CoordinateSequence coordinates) {
        return GEOMETRY_FACTORY.createLineString(coordinates);
    }

    public static org.locationtech.jts.geom.Geometry createJtsEmptyPolygon() {
        return GEOMETRY_FACTORY.createPolygon();
    }

    public static String getGeometryInvalidReason(org.locationtech.jts.geom.Geometry geometry) {
        IsValidOp validOp = new IsValidOp(geometry);
        IsSimpleOp simpleOp = new IsSimpleOp(geometry);
        try {
            TopologyValidationError err = validOp.getValidationError();
            if (err != null) {
                return err.getMessage();
            }
        }
        catch (UnsupportedOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Geometry type not valid", (Throwable)e);
        }
        if (!simpleOp.isSimple()) {
            String errorDescription;
            String geometryType = geometry.getGeometryType();
            switch (GeometryType.getForJtsGeometryType(geometryType)) {
                case POINT: {
                    errorDescription = "Invalid point";
                    break;
                }
                case MULTI_POINT: {
                    errorDescription = "Repeated point";
                    break;
                }
                case LINE_STRING: 
                case MULTI_LINE_STRING: {
                    errorDescription = "Self-intersection at or near";
                    break;
                }
                case POLYGON: 
                case MULTI_POLYGON: 
                case GEOMETRY_COLLECTION: {
                    errorDescription = "Topology exception at or near";
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unknown geometry type: %s", geometryType));
                }
            }
            Coordinate nonSimpleLocation = simpleOp.getNonSimpleLocation();
            return String.format("[%s] %s: (%s %s)", geometryType, errorDescription, nonSimpleLocation.getX(), nonSimpleLocation.getY());
        }
        return null;
    }
}

