/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

public final class GeometryUtils {
    private GeometryUtils() {
    }

    private static double translateFromAVNaN(double n) {
        return n < -1.0E38 ? Double.NaN : n;
    }

    public static double translateToAVNaN(double n) {
        return Double.isNaN(n) ? -1.7976931348623157E308 : n;
    }

    public static boolean isEsriNaN(double d) {
        return Double.isNaN(d) || Double.isNaN(GeometryUtils.translateFromAVNaN(d));
    }
}

