/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.ogc.OGCConcreteGeometryCollection;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.google.common.base.Verify;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;

public final class GeometryUtils {
    private static final int POINT_TYPE = 1;
    public static final String POINT = "Point";
    public static final String LINE_STRING = "LineString";
    public static final String POLYGON = "Polygon";
    public static final String MULTI_POINT = "MultiPoint";
    public static final String MULTI_LINE_STRING = "MultiLineString";
    public static final String MULTI_POLYGON = "MultiPolygon";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    public static final int SPATIAL_REFERENCE_UNKNOWN = 0;

    private GeometryUtils() {
    }

    public static GeometryTypeName valueOf(String type) {
        switch (type) {
            case "Point": {
                return GeometryTypeName.POINT;
            }
            case "MultiPoint": {
                return GeometryTypeName.MULTI_POINT;
            }
            case "LineString": {
                return GeometryTypeName.LINE_STRING;
            }
            case "MultiLineString": {
                return GeometryTypeName.MULTI_LINE_STRING;
            }
            case "Polygon": {
                return GeometryTypeName.POLYGON;
            }
            case "MultiPolygon": {
                return GeometryTypeName.MULTI_POLYGON;
            }
            case "GeometryCollection": {
                return GeometryTypeName.GEOMETRY_COLLECTION;
            }
        }
        throw new IllegalArgumentException("Invalid Geometry Type: " + type);
    }

    private static double translateFromAVNaN(double n) {
        return n < -1.0E38 ? Double.NaN : n;
    }

    public static boolean isEsriNaN(double d) {
        return Double.isNaN(d) || Double.isNaN(GeometryUtils.translateFromAVNaN(d));
    }

    @Nullable
    public static Envelope deserializeEnvelope(Slice shape) {
        if (shape == null) {
            return null;
        }
        BasicSliceInput input = shape.getInput();
        Envelope overallEnvelope = null;
        if (input.available() > 0) {
            boolean isGeometryCollection;
            byte code = input.readByte();
            boolean bl = isGeometryCollection = code == GeometryTypeName.GEOMETRY_COLLECTION.code();
            while (input.available() > 0) {
                int length = isGeometryCollection ? input.readInt() : input.available();
                ByteBuffer buffer = input.readSlice(length).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                int type = buffer.getInt();
                Envelope envelope = null;
                if (type == 1) {
                    double x = buffer.getDouble();
                    double y = buffer.getDouble();
                    if (!GeometryUtils.isEsriNaN(x)) {
                        Verify.verify((!GeometryUtils.isEsriNaN(y) ? 1 : 0) != 0);
                        envelope = new Envelope(x, y, x, y);
                    }
                } else {
                    double xMin = buffer.getDouble();
                    double yMin = buffer.getDouble();
                    double xMax = buffer.getDouble();
                    double yMax = buffer.getDouble();
                    if (!GeometryUtils.isEsriNaN(xMin)) {
                        Verify.verify((!GeometryUtils.isEsriNaN(xMax) ? 1 : 0) != 0);
                        Verify.verify((!GeometryUtils.isEsriNaN(yMin) ? 1 : 0) != 0);
                        Verify.verify((!GeometryUtils.isEsriNaN(yMax) ? 1 : 0) != 0);
                        envelope = new Envelope(xMin, yMin, xMax, yMax);
                    }
                }
                if (envelope == null) continue;
                if (overallEnvelope == null) {
                    overallEnvelope = envelope;
                    continue;
                }
                overallEnvelope.merge(envelope);
            }
        }
        return overallEnvelope;
    }

    public static OGCGeometry deserialize(Slice shape) {
        if (shape == null) {
            return null;
        }
        BasicSliceInput input = shape.getInput();
        ArrayList<OGCGeometry> geometries = new ArrayList<OGCGeometry>();
        if (input.available() > 0) {
            boolean isGeometryCollection;
            byte code = input.readByte();
            boolean bl = isGeometryCollection = code == GeometryTypeName.GEOMETRY_COLLECTION.code();
            while (input.available() > 0) {
                geometries.add(GeometryUtils.readGeometry(isGeometryCollection, input));
            }
        }
        if (geometries.isEmpty()) {
            return new OGCConcreteGeometryCollection(Collections.emptyList(), null);
        }
        if (geometries.size() == 1) {
            return (OGCGeometry)geometries.get(0);
        }
        return new OGCConcreteGeometryCollection(geometries, null);
    }

    private static OGCGeometry readGeometry(boolean isGeometryCollection, BasicSliceInput input) {
        int length = isGeometryCollection ? input.readInt() : input.available();
        ByteBuffer buffer = input.readSlice(length).toByteBuffer().slice().order(ByteOrder.LITTLE_ENDIAN);
        Geometry esriGeometry = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, buffer);
        return OGCGeometry.createFromEsriGeometry((Geometry)esriGeometry, null);
    }

    public static Slice serialize(OGCGeometry input) {
        Geometry geometry;
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(100);
        sliceOutput.appendByte(GeometryUtils.valueOf(input.geometryType()).code());
        GeometryCursor cursor = input.getEsriGeometryCursor();
        boolean isGeometryCollection = input.geometryType().equals(GEOMETRY_COLLECTION);
        while ((geometry = cursor.next()) != null) {
            byte[] shape = GeometryEngine.geometryToEsriShape((Geometry)geometry);
            if (isGeometryCollection) {
                sliceOutput.appendInt(shape.length);
            }
            sliceOutput.appendBytes(shape);
        }
        return sliceOutput.slice();
    }

    public static enum GeometryTypeName {
        POINT(0),
        MULTI_POINT(1),
        LINE_STRING(2),
        MULTI_LINE_STRING(3),
        POLYGON(4),
        MULTI_POLYGON(5),
        GEOMETRY_COLLECTION(6);

        private final int code;

        private GeometryTypeName(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

