/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.ogc.OGCConcreteGeometryCollection;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCGeometryCollection;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import io.airlift.slice.SizeOf;
import org.openjdk.jol.info.ClassLayout;

public class GeometryMemorySizeUtilsPackageWorkaround {
    private static final int VERTEX_DESCRIPTOR_INSTANCE_SIZE = ClassLayout.parseClass(VertexDescription.class).instanceSize() + Math.toIntExact(SizeOf.sizeOfDoubleArray((int)2) + SizeOf.sizeOfIntArray((int)21));
    private static final int MULTI_POINT_IMPL_INSTANCE_SIZE = ClassLayout.parseClass(MultiPointImpl.class).instanceSize();
    private static final int MULTI_PATH_IMPL_INSTANCE_SIZE = ClassLayout.parseClass(MultiPathImpl.class).instanceSize();
    private static final int ATTRIBUTE_STREAM_OF_DBL_INSTANCE_SIZE = ClassLayout.parseClass(AttributeStreamOfDbl.class).instanceSize();
    private static final int ATTRIBUTE_STREAM_OF_INT32_INSTANCE_SIZE = ClassLayout.parseClass(AttributeStreamOfInt32.class).instanceSize();
    private static final int ATTRIBUTE_STREAM_OF_INT8_INSTANCE_SIZE = ClassLayout.parseClass(AttributeStreamOfInt8.class).instanceSize();
    private static final int ENVELOPE_INSTANCE_SIZE = ClassLayout.parseClass(Envelope.class).instanceSize() + VERTEX_DESCRIPTOR_INSTANCE_SIZE + ClassLayout.parseClass(Envelope2D.class).instanceSize();
    private static final int POINT_INSTANCE_SIZE = ClassLayout.parseClass(OGCPoint.class).instanceSize() + ClassLayout.parseClass(Point.class).instanceSize() + Math.toIntExact(SizeOf.sizeOfDoubleArray((int)2)) + VERTEX_DESCRIPTOR_INSTANCE_SIZE;
    private static final int MULTI_POINT_INSTANCE_SIZE = ClassLayout.parseClass(OGCMultiPoint.class).instanceSize() + ClassLayout.parseClass(MultiPoint.class).instanceSize() + MULTI_POINT_IMPL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_DBL_INSTANCE_SIZE;
    private static final int LINE_STRING_INSTANCE_SIZE = ClassLayout.parseClass(OGCLineString.class).instanceSize() + ClassLayout.parseClass(Polyline.class).instanceSize() + MULTI_PATH_IMPL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_DBL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT32_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT8_INSTANCE_SIZE;
    private static final int MULTI_LINE_STRING_INSTANCE_SIZE = ClassLayout.parseClass(OGCMultiLineString.class).instanceSize() + ClassLayout.parseClass(Polyline.class).instanceSize() + MULTI_PATH_IMPL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_DBL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT32_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT8_INSTANCE_SIZE;
    private static final int POLYGON_INSTANCE_SIZE = ClassLayout.parseClass(OGCPolygon.class).instanceSize() + ClassLayout.parseClass(Polygon.class).instanceSize() + MULTI_PATH_IMPL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_DBL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT32_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT8_INSTANCE_SIZE;
    private static final int MULTI_POLYGON_INSTANCE_SIZE = ClassLayout.parseClass(OGCMultiPolygon.class).instanceSize() + ClassLayout.parseClass(Polygon.class).instanceSize() + MULTI_PATH_IMPL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_DBL_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT32_INSTANCE_SIZE + ATTRIBUTE_STREAM_OF_INT8_INSTANCE_SIZE;
    private static final int GEOMETRY_COLLECTION_INSTANCE_SIZE = ClassLayout.parseClass(OGCConcreteGeometryCollection.class).instanceSize();

    private GeometryMemorySizeUtilsPackageWorkaround() {
    }

    public static long getEstimatedMemorySizeInBytes(OGCGeometry geometry) {
        switch (geometry.geometryType()) {
            case "Point": {
                return POINT_INSTANCE_SIZE;
            }
            case "MultiPoint": {
                int pointCount = ((MultiVertexGeometry)geometry.getEsriGeometry()).getPointCount();
                return (long)(MULTI_POINT_INSTANCE_SIZE + ENVELOPE_INSTANCE_SIZE) + SizeOf.sizeOfDoubleArray((int)(2 * pointCount));
            }
            case "LineString": {
                return (long)LINE_STRING_INSTANCE_SIZE + GeometryMemorySizeUtilsPackageWorkaround.getEstimatedMemorySizeInBytes((MultiPath)geometry.getEsriGeometry());
            }
            case "MultiLineString": {
                return (long)MULTI_LINE_STRING_INSTANCE_SIZE + GeometryMemorySizeUtilsPackageWorkaround.getEstimatedMemorySizeInBytes((MultiPath)geometry.getEsriGeometry());
            }
            case "Polygon": {
                return (long)POLYGON_INSTANCE_SIZE + GeometryMemorySizeUtilsPackageWorkaround.getEstimatedMemorySizeInBytes((MultiPath)geometry.getEsriGeometry());
            }
            case "MultiPolygon": {
                return (long)MULTI_POLYGON_INSTANCE_SIZE + GeometryMemorySizeUtilsPackageWorkaround.getEstimatedMemorySizeInBytes((MultiPath)geometry.getEsriGeometry());
            }
            case "GeometryCollection": {
                return GeometryMemorySizeUtilsPackageWorkaround.getEstimatedMemorySizeInBytes((OGCGeometryCollection)geometry);
            }
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + geometry.geometryType());
    }

    private static long getEstimatedMemorySizeInBytes(MultiPath multiPath) {
        int pointCount = multiPath.getPointCount();
        int pathCount = multiPath.getPathCount();
        return (long)ENVELOPE_INSTANCE_SIZE + SizeOf.sizeOfDoubleArray((int)(2 * pointCount)) + SizeOf.sizeOfIntArray((int)pathCount) + SizeOf.sizeOfByteArray((int)pathCount);
    }

    private static long getEstimatedMemorySizeInBytes(OGCGeometryCollection collection) {
        long size = GEOMETRY_COLLECTION_INSTANCE_SIZE;
        for (int i = 0; i < collection.numGeometries(); ++i) {
            size += GeometryMemorySizeUtilsPackageWorkaround.getEstimatedMemorySizeInBytes(collection.geometryN(i));
        }
        return size;
    }
}

