/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCConcreteGeometryCollection;
import com.esri.core.geometry.ogc.OGCGeometry;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;

public final class GeometryUtils {
    public static final String POINT = "Point";
    public static final String LINE_STRING = "LineString";
    public static final String POLYGON = "Polygon";
    public static final String MULTI_POINT = "MultiPoint";
    public static final String MULTI_LINE_STRING = "MultiLineString";
    public static final String MULTI_POLYGON = "MultiPolygon";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    public static final int SPATIAL_REFERENCE_UNKNOWN = 0;

    private GeometryUtils() {
    }

    public static GeometryTypeName valueOf(String type) {
        switch (type) {
            case "Point": {
                return GeometryTypeName.POINT;
            }
            case "MultiPoint": {
                return GeometryTypeName.MULTI_POINT;
            }
            case "LineString": {
                return GeometryTypeName.LINE_STRING;
            }
            case "MultiLineString": {
                return GeometryTypeName.MULTI_LINE_STRING;
            }
            case "Polygon": {
                return GeometryTypeName.POLYGON;
            }
            case "MultiPolygon": {
                return GeometryTypeName.MULTI_POLYGON;
            }
            case "GeometryCollection": {
                return GeometryTypeName.GEOMETRY_COLLECTION;
            }
        }
        throw new IllegalArgumentException("Invalid Geometry Type: " + type);
    }

    public static OGCGeometry deserialize(Slice shape) {
        if (shape == null) {
            return null;
        }
        BasicSliceInput input = shape.getInput();
        int spatialReferenceId = input.readInt();
        SpatialReference spatialReference = null;
        if (spatialReferenceId != 0) {
            spatialReference = SpatialReference.create((int)spatialReferenceId);
        }
        ArrayList<OGCGeometry> geometries = new ArrayList<OGCGeometry>();
        while (input.available() > 0) {
            int length = input.readInt();
            ByteBuffer buffer = input.readSlice(length).toByteBuffer().slice().order(ByteOrder.LITTLE_ENDIAN);
            Geometry esriGeometry = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, buffer);
            OGCGeometry geometry = OGCGeometry.createFromEsriGeometry((Geometry)esriGeometry, (SpatialReference)spatialReference);
            geometries.add(geometry);
        }
        if (geometries.isEmpty()) {
            return new OGCConcreteGeometryCollection(Collections.emptyList(), spatialReference);
        }
        if (geometries.size() == 1) {
            return (OGCGeometry)geometries.get(0);
        }
        return new OGCConcreteGeometryCollection(geometries, spatialReference);
    }

    public static Slice serialize(OGCGeometry input) {
        Geometry geometry;
        int spatialReferenceId = input.SRID();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(100);
        sliceOutput.appendInt(spatialReferenceId);
        GeometryCursor cursor = input.getEsriGeometryCursor();
        while ((geometry = cursor.next()) != null) {
            byte[] shape = GeometryEngine.geometryToEsriShape((Geometry)geometry);
            sliceOutput.appendInt(shape.length);
            sliceOutput.appendBytes(shape);
        }
        return sliceOutput.slice();
    }

    public static enum GeometryTypeName {
        POINT,
        MULTI_POINT,
        LINE_STRING,
        MULTI_LINE_STRING,
        POLYGON,
        MULTI_POLYGON,
        GEOMETRY_COLLECTION;

    }
}

