/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.rest;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StatusResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.functionNamespace.ForRestServer;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.functionNamespace.rest.RestErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestBasedFunctionApis {
    public static final String ALL_FUNCTIONS_ENDPOINT = "/v1/functions";
    private final HttpClient httpClient;
    private final JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> functionSignatureMapJsonCodec;
    private final String restUrl;

    @Inject
    public RestBasedFunctionApis(JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec, @ForRestServer HttpClient httpClient, @Named(value="restUrl") String restUrl) {
        this.functionSignatureMapJsonCodec = Objects.requireNonNull(nativeFunctionSignatureMapJsonCodec, "nativeFunctionSignatureMapJsonCodec is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.restUrl = Objects.requireNonNull(restUrl, "restUrl is null");
    }

    public String getFunctionsETag() {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create(this.restUrl)).appendPath(ALL_FUNCTIONS_ENDPOINT).build();
        Request.builder();
        Request request = Request.Builder.prepareHead().setUri(uri).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        return response.getHeader("ETag");
    }

    public UdfFunctionSignatureMap getAllFunctions() {
        return this.getFunctionsAt(ALL_FUNCTIONS_ENDPOINT);
    }

    public UdfFunctionSignatureMap getFunctions(String schema) {
        return this.getFunctionsAt("/v1/functions/" + schema);
    }

    public UdfFunctionSignatureMap getFunctions(String schema, String functionName) {
        return this.getFunctionsAt("/v1/functions/" + schema + "/" + functionName);
    }

    public String addFunction(String schema, String functionName, JsonBasedUdfFunctionMetadata metadata) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Add Function is yet to be added");
    }

    private UdfFunctionSignatureMap getFunctionsAt(String endpoint) throws IllegalStateException {
        try {
            URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create(this.restUrl)).appendPath(endpoint).build();
            Request.builder();
            Request request = Request.Builder.prepareGet().setUri(uri).build();
            Map nativeFunctionSignatureMap = (Map)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.functionSignatureMapJsonCodec));
            return new UdfFunctionSignatureMap((Map)ImmutableMap.copyOf((Map)nativeFunctionSignatureMap));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)RestErrorCode.REST_SERVER_FUNCTION_FETCH_ERROR, "Failed to fetch function definitions from REST server: " + e.getMessage(), (Throwable)e);
        }
    }
}

