/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.json;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.functionNamespace.json.FunctionDefinitionProvider;
import com.facebook.presto.plugin.base.JsonUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonFileBasedFunctionDefinitionProvider
implements FunctionDefinitionProvider {
    private static final Logger log = Logger.get(JsonFileBasedFunctionDefinitionProvider.class);
    private static final int MAX_DIRECTORY_DEPTH = 4;
    private static final String JSON_FILE_EXTENSION = ".json";

    @Override
    public UdfFunctionSignatureMap getUdfDefinition(String filePath) {
        HashMap udfSignatureMap = new HashMap();
        try {
            for (Path path : this.getFilesInPath(filePath, 4)) {
                udfSignatureMap.putAll(((UdfFunctionSignatureMap)JsonUtils.parseJson((Path)path, UdfFunctionSignatureMap.class)).getUDFSignatureMap());
            }
            return new UdfFunctionSignatureMap(udfSignatureMap);
        }
        catch (Exception e) {
            log.info("Failed to load function definition for JsonFileBasedFunctionNamespaceManager " + e.getMessage());
            return null;
        }
    }

    private List<Path> getFilesInPath(String filePath, int maxDirectoryDepth) throws IOException {
        try (Stream<Path> stream = Files.find(Path.of(filePath, new String[0]), maxDirectoryDepth, (p, basicFileAttributes) -> p.getFileName().toString().toLowerCase(Locale.ENGLISH).endsWith(JSON_FILE_EXTENSION), new FileVisitOption[0]);){
            List<Path> list = stream.collect(Collectors.toList());
            return list;
        }
    }
}

