/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.execution;

import com.facebook.presto.functionNamespace.execution.UdfExecutionFailure;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.thrift.api.udf.ThriftUdfServiceException;
import com.facebook.presto.thrift.api.udf.UdfExecutionFailureInfo;
import com.google.common.base.MoreObjects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExceptionUtils {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");

    private ExceptionUtils() {
    }

    public static PrestoException toPrestoException(ThriftUdfServiceException thriftException) {
        UdfExecutionFailure cause = ExceptionUtils.toUdfExecutionException(thriftException.getFailureInfo());
        PrestoException prestoException = new PrestoException(() -> ((ThriftUdfServiceException)thriftException).getErrorCode(), (String)MoreObjects.firstNonNull((Object)cause.getMessage(), (Object)"Error executing remote function"), (Throwable)cause);
        prestoException.addSuppressed((Throwable)thriftException);
        return prestoException;
    }

    private static UdfExecutionFailure toUdfExecutionException(UdfExecutionFailureInfo failureInfo) {
        UdfExecutionFailure exception = new UdfExecutionFailure(failureInfo.getType(), failureInfo.getMessage(), failureInfo.getCause() == null ? null : ExceptionUtils.toUdfExecutionException(failureInfo.getCause()));
        for (UdfExecutionFailureInfo suppressed : failureInfo.getSuppressed()) {
            exception.addSuppressed(ExceptionUtils.toUdfExecutionException(suppressed));
        }
        exception.setStackTrace((StackTraceElement[])failureInfo.getStack().stream().map(ExceptionUtils::toStackTraceElement).toArray(StackTraceElement[]::new));
        return exception;
    }

    private static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }
}

