/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.InvalidFunctionHandleException;
import com.facebook.presto.functionNamespace.ServingCatalog;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.mysql.FunctionNamespaceDao;
import com.facebook.presto.functionNamespace.mysql.FunctionNamespacesTableCustomizerFactory;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.mysql.SqlFunctionsTableCustomizerFactory;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRecord;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.QualifiedFunctionName;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jdbi.v3.core.Jdbi;

public class MySqlFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private static final int MAX_CATALOG_NAME_LENGTH = 128;
    private static final int MAX_SCHEMA_NAME_LENGTH = 128;
    private static final int MAX_FUNCTION_NAME_LENGTH = 256;
    private static final int MAX_PARAMETER_TYPES_LENGTH = 500;
    private static final int MAX_RETURN_TYPE_LENGTH = 256;
    private final Jdbi jdbi;
    private final FunctionNamespaceDao functionNamespaceDao;

    @Inject
    public MySqlFunctionNamespaceManager(Jdbi jdbi, FunctionNamespaceDao functionNamespaceDao, SqlInvokedFunctionNamespaceManagerConfig managerConfig, MySqlFunctionNamespaceManagerConfig dbManagerConfig, @ServingCatalog String catalogName) {
        super(catalogName, managerConfig);
        this.jdbi = Objects.requireNonNull(jdbi, "jdbi is null");
        this.functionNamespaceDao = Objects.requireNonNull(functionNamespaceDao, "functionNamespaceDao is null");
        ((FunctionNamespacesTableCustomizerFactory.Config)jdbi.getConfig(FunctionNamespacesTableCustomizerFactory.Config.class)).setTableName(dbManagerConfig.getFunctionNamespacesTableName());
        ((SqlFunctionsTableCustomizerFactory.Config)jdbi.getConfig(SqlFunctionsTableCustomizerFactory.Config.class)).setTableName(dbManagerConfig.getFunctionsTableName());
    }

    @PostConstruct
    public void initialize() {
        this.functionNamespaceDao.createFunctionNamespacesTableIfNotExists();
        this.functionNamespaceDao.createSqlFunctionsTableIfNotExists();
    }

    public Collection<SqlInvokedFunction> listFunctions() {
        return this.functionNamespaceDao.listFunctions(this.getCatalogName());
    }

    @Override
    protected Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedFunctionName functionName) {
        this.checkCatalog(functionName);
        return this.functionNamespaceDao.getFunctions(functionName.getFunctionNamespace().getCatalogName(), functionName.getFunctionNamespace().getSchemaName(), functionName.getFunctionName());
    }

    @Override
    protected FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        this.checkCatalog((FunctionHandle)functionHandle);
        Optional<SqlInvokedFunction> function = this.functionNamespaceDao.getFunction(functionHandle.getFunctionId(), functionHandle.getVersion());
        if (!function.isPresent()) {
            throw new InvalidFunctionHandleException((FunctionHandle)functionHandle);
        }
        return MySqlFunctionNamespaceManager.sqlInvokedFunctionToMetadata(function.get());
    }

    @Override
    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        this.checkCatalog((FunctionHandle)functionHandle);
        Optional<SqlInvokedFunction> function = this.functionNamespaceDao.getFunction(functionHandle.getFunctionId(), functionHandle.getVersion());
        if (!function.isPresent()) {
            throw new InvalidFunctionHandleException((FunctionHandle)functionHandle);
        }
        return MySqlFunctionNamespaceManager.sqlInvokedFunctionToImplementation(function.get());
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        this.checkCatalog((SqlFunction)function);
        Preconditions.checkArgument((!function.getVersion().isPresent() ? 1 : 0) != 0, (String)"function '%s' is already versioned", (Object)function);
        QualifiedFunctionName functionName = function.getFunctionId().getFunctionName();
        MySqlFunctionNamespaceManager.checkFieldLength("Catalog name", functionName.getFunctionNamespace().getCatalogName(), 128);
        MySqlFunctionNamespaceManager.checkFieldLength("Schema name", functionName.getFunctionNamespace().getSchemaName(), 128);
        if (!this.functionNamespaceDao.functionNamespaceExists(functionName.getFunctionNamespace().getCatalogName(), functionName.getFunctionNamespace().getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Function namespace not found: %s", functionName.getFunctionNamespace()));
        }
        MySqlFunctionNamespaceManager.checkFieldLength("Function name", functionName.getFunctionName(), 256);
        MySqlFunctionNamespaceManager.checkFieldLength("Parameter types", function.getFunctionId().getArgumentTypes().stream().map(TypeSignature::toString).collect(Collectors.joining(",")), 500);
        MySqlFunctionNamespaceManager.checkFieldLength("Return type", function.getSignature().getReturnType().toString(), 256);
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(FunctionNamespaceDao.class);
            Optional<SqlInvokedFunctionRecord> latestVersion = transactionDao.getLatestRecordForUpdate(function.getFunctionId());
            if (!replace && latestVersion.isPresent() && !latestVersion.get().isDeleted()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Function already exists: " + function.getFunctionId());
            }
            if (!latestVersion.isPresent() || !latestVersion.get().getFunction().hasSameDefinitionAs(function)) {
                long newVersion = latestVersion.map(SqlInvokedFunctionRecord::getFunction).flatMap(SqlInvokedFunction::getVersion).orElse(0L) + 1L;
                this.insertSqlInvokedFunction(transactionDao, function, newVersion);
            } else if (latestVersion.get().isDeleted()) {
                SqlInvokedFunction latest = latestVersion.get().getFunction();
                Preconditions.checkState((boolean)latest.getVersion().isPresent(), (String)"Function version missing: %s", (Object)latest.getFunctionId());
                transactionDao.setDeletionStatus(latest.getFunctionId(), (Long)latest.getVersion().get(), false);
            }
        });
        this.refreshFunctionsCache(functionName);
    }

    public void alterFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        this.checkCatalog(functionName);
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(FunctionNamespaceDao.class);
            List<SqlInvokedFunction> functions = this.getSqlFunctions(transactionDao, functionName, parameterTypes);
            MySqlFunctionNamespaceManager.checkUnique(functions, functionName);
            MySqlFunctionNamespaceManager.checkExists(functions, functionName, parameterTypes);
            SqlInvokedFunction latest = functions.get(0);
            RoutineCharacteristics.Builder routineCharacteristics = RoutineCharacteristics.builder((RoutineCharacteristics)latest.getRoutineCharacteristics());
            alterRoutineCharacteristics.getNullCallClause().ifPresent(arg_0 -> ((RoutineCharacteristics.Builder)routineCharacteristics).setNullCallClause(arg_0));
            SqlInvokedFunction altered = new SqlInvokedFunction(latest.getFunctionId().getFunctionName(), latest.getParameters(), latest.getSignature().getReturnType(), latest.getDescription(), routineCharacteristics.build(), latest.getBody(), Optional.empty());
            if (!altered.hasSameDefinitionAs(latest)) {
                Preconditions.checkState((boolean)latest.getVersion().isPresent(), (String)"Function version missing: %s", (Object)latest.getFunctionId());
                this.insertSqlInvokedFunction(transactionDao, altered, (Long)latest.getVersion().get() + 1L);
            }
        });
        this.refreshFunctionsCache(functionName);
    }

    public void dropFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        this.checkCatalog(functionName);
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(FunctionNamespaceDao.class);
            List<SqlInvokedFunction> functions = this.getSqlFunctions(transactionDao, functionName, parameterTypes);
            MySqlFunctionNamespaceManager.checkUnique(functions, functionName);
            MySqlFunctionNamespaceManager.checkExists(functions, functionName, parameterTypes);
            SqlInvokedFunction latest = functions.get(0);
            Preconditions.checkState((boolean)latest.getVersion().isPresent(), (String)"Function version missing: %s", (Object)latest.getFunctionId());
            transactionDao.setDeletionStatus(latest.getFunctionId(), (Long)latest.getVersion().get(), true);
        });
        this.refreshFunctionsCache(functionName);
    }

    private List<SqlInvokedFunction> getSqlFunctions(FunctionNamespaceDao functionNamespaceDao, QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes) {
        List<Object> records = new ArrayList();
        if (parameterTypes.isPresent()) {
            functionNamespaceDao.getLatestRecordForUpdate(new SqlFunctionId(functionName, parameterTypes.get())).ifPresent(records::add);
        } else {
            CatalogSchemaName functionNamespace = functionName.getFunctionNamespace();
            records = functionNamespaceDao.getLatestRecordsForUpdate(functionNamespace.getCatalogName(), functionNamespace.getSchemaName(), functionName.getFunctionName());
        }
        return (List)records.stream().filter(record -> !record.isDeleted()).map(SqlInvokedFunctionRecord::getFunction).collect(ImmutableList.toImmutableList());
    }

    private void insertSqlInvokedFunction(FunctionNamespaceDao functionNamespaceDao, SqlInvokedFunction function, long version) {
        QualifiedFunctionName functionName = function.getFunctionId().getFunctionName();
        functionNamespaceDao.insertFunction(function.getFunctionId(), version, functionName.getFunctionNamespace().getCatalogName(), functionName.getFunctionNamespace().getSchemaName(), functionName.getFunctionName(), function.getParameters(), function.getSignature().getReturnType(), function.getDescription(), function.getRoutineCharacteristics(), function.getBody());
    }

    private static void checkFieldLength(String fieldName, String field, int maxLength) {
        if (field.length() > maxLength) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("%s exceeds max length of %s: %s", fieldName, maxLength, field));
        }
    }

    private static void checkUnique(List<SqlInvokedFunction> functions, QualifiedFunctionName functionName) {
        if (functions.size() > 1) {
            String signatures = functions.stream().map(SqlFunction::getSignature).map(Signature::toString).collect(Collectors.joining("; "));
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Function '%s' has multiple signatures: %s. Please specify parameter types.", functionName, signatures));
        }
    }

    private static void checkExists(List<SqlInvokedFunction> functions, QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes) {
        if (functions.isEmpty()) {
            String formattedParameterTypes = parameterTypes.map(types -> types.stream().map(TypeSignature::toString).collect(Collectors.joining(",", "(", ")"))).orElse("");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Function not found: %s%s", functionName, formattedParameterTypes));
        }
    }
}

