/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleConfig;
import com.facebook.presto.example.ExampleConnector;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleHandleResolver;
import com.facebook.presto.example.ExampleMetadata;
import com.facebook.presto.example.ExampleRecordSetProvider;
import com.facebook.presto.example.ExampleSplitManager;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import javax.inject.Inject;

public class ExampleModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;

    public ExampleModule(String connectorId, TypeManager typeManager) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connector id is null");
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(ExampleConnector.class).in(Scopes.SINGLETON);
        binder.bind(ExampleConnectorId.class).toInstance((Object)new ExampleConnectorId(this.connectorId));
        binder.bind(ExampleMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ExampleClient.class).in(Scopes.SINGLETON);
        binder.bind(ExampleSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ExampleRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ExampleHandleResolver.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(ExampleConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(ExampleTable.class));
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object[])new Object[]{value});
            return type;
        }
    }
}

