/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleColumnHandle;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExampleRecordSet;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class ExampleRecordSetProvider
implements ConnectorRecordSetProvider {
    private final String connectorId;

    @Inject
    public ExampleRecordSetProvider(ExampleConnectorId connectorId) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
    }

    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"partitionChunk is null");
        Preconditions.checkArgument((boolean)(split instanceof ExampleSplit));
        ExampleSplit exampleSplit = (ExampleSplit)split;
        Preconditions.checkArgument((boolean)exampleSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            Preconditions.checkArgument((boolean)(connectorColumnHandle instanceof ExampleColumnHandle));
            handles.add((Object)((ExampleColumnHandle)connectorColumnHandle));
        }
        return new ExampleRecordSet(exampleSplit, (List<ExampleColumnHandle>)handles.build());
    }
}

