/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExamplePartition;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ExampleSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final ExampleClient exampleClient;

    @Inject
    public ExampleSplitManager(ExampleConnectorId connectorId, ExampleClient exampleClient) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.exampleClient = (ExampleClient)Preconditions.checkNotNull((Object)exampleClient, (Object)"client is null");
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof ExampleTableHandle && ((ExampleTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public List<Partition> getPartitions(TableHandle tableHandle, Map<ColumnHandle, Object> bindings) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof ExampleTableHandle), (Object)"tableHandle is not an instance of ExampleTableHandle");
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        return ImmutableList.of((Object)new ExamplePartition(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName()));
    }

    public Iterable<Split> getPartitionSplits(TableHandle tableHandle, List<Partition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        Preconditions.checkArgument((partitions.size() == 1 ? 1 : 0) != 0, (String)"Expected one partition but got %s", (Object[])new Object[]{partitions.size()});
        Partition partition = partitions.get(0);
        Preconditions.checkArgument((boolean)(partition instanceof ExamplePartition), (Object)"partition is not an instance of ExamplePartition");
        ExamplePartition examplePartition = (ExamplePartition)partition;
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        ExampleTable table = this.exampleClient.getTable(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        Preconditions.checkState((table != null ? 1 : 0) != 0, (String)"Table %s.%s no longer exists", (Object[])new Object[]{exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName()});
        ArrayList splits = Lists.newArrayList();
        for (URI uri : table.getSources()) {
            splits.add(new ExampleSplit(this.connectorId, examplePartition.getSchemaName(), examplePartition.getTableName(), uri));
        }
        Collections.shuffle(splits);
        return splits;
    }
}

