/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleMetadata;
import com.facebook.presto.example.ExampleRecordSetProvider;
import com.facebook.presto.example.ExampleSplitManager;
import com.facebook.presto.example.ExampleTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleConnector
implements Connector {
    private static final Logger log = Logger.get(ExampleConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ExampleMetadata metadata;
    private final ExampleSplitManager splitManager;
    private final ExampleRecordSetProvider recordSetProvider;

    @Inject
    public ExampleConnector(LifeCycleManager lifeCycleManager, ExampleMetadata metadata, ExampleSplitManager splitManager, ExampleRecordSetProvider recordSetProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return ExampleTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

