/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import java.util.Arrays;

class IntArrayList {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private int[] array;
    private int size;

    IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(String.format("Initial capacity '%s' is negative", initialCapacity));
        }
        this.array = new int[initialCapacity];
    }

    IntArrayList() {
        this(16);
    }

    int[] elements() {
        return this.array;
    }

    private void grow(int newCapacity) {
        if (this.array.length == 0x7FFFFFF7) {
            throw new IllegalStateException("Array reached maximum size");
        }
        if (newCapacity > this.array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)this.array.length, (long)newCapacity), 0x7FFFFFF7L);
            this.array = Arrays.copyOf(this.array, newLength);
        }
    }

    void add(int element) {
        this.grow(this.size + 1);
        this.array[this.size++] = element;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }
}

