/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.PageBuilderStatus;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BlockBuilderStatus {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(BlockBuilderStatus.class).instanceSize() + PageBuilderStatus.INSTANCE_SIZE;
    private final PageBuilderStatus pageBuilderStatus;
    private int currentSize;

    BlockBuilderStatus(PageBuilderStatus pageBuilderStatus) {
        this.pageBuilderStatus = Objects.requireNonNull(pageBuilderStatus, "pageBuilderStatus must not be null");
    }

    public int getMaxPageSizeInBytes() {
        return this.pageBuilderStatus.getMaxPageSizeInBytes();
    }

    public void addBytes(int bytes) {
        this.currentSize += bytes;
        this.pageBuilderStatus.addBytes(bytes);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BlockBuilderStatus{");
        buffer.append(", currentSize=").append(this.currentSize);
        buffer.append('}');
        return buffer.toString();
    }
}

