/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.array;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public class AdaptiveLongBigArray {
    static final int INSTANCE_SIZE = ClassLayout.parseClass(AdaptiveLongBigArray.class).instanceSize();
    static final int INITIAL_SEGMENT_LENGTH = 16384;
    static final int MAX_SEGMENT_LENGTH = 0x2000000;
    static final long MAX_SEGMENT_SIZE_IN_BYTES = SizeOf.sizeOfLongArray((int)0x2000000);
    static final int INITIAL_SEGMENTS = 10;
    static final int SEGMENT_SHIFT = 25;
    static final int SEGMENT_MASK = 0x1FFFFFF;
    private long[][] array = new long[10][];
    private int segments;
    private int capacity;

    public long getRetainedSizeInBytes() {
        long result = (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array);
        if (this.segments == 1) {
            result += SizeOf.sizeOfLongArray((int)this.array[0].length);
        } else if (this.segments > 1) {
            result += (long)this.segments * MAX_SEGMENT_SIZE_IN_BYTES;
        }
        return result;
    }

    public long get(int index) {
        return this.array[AdaptiveLongBigArray.segment(index)][AdaptiveLongBigArray.offset(index)];
    }

    public void set(int index, long value) {
        this.array[AdaptiveLongBigArray.segment((int)index)][AdaptiveLongBigArray.offset((int)index)] = value;
    }

    public void swap(int first, int second) {
        long[] firstSegment = this.array[AdaptiveLongBigArray.segment(first)];
        int firstOffset = AdaptiveLongBigArray.offset(first);
        long[] secondSegment = this.array[AdaptiveLongBigArray.segment(second)];
        int secondOffset = AdaptiveLongBigArray.offset(second);
        long tmp = firstSegment[firstOffset];
        firstSegment[firstOffset] = secondSegment[secondOffset];
        secondSegment[secondOffset] = tmp;
    }

    public void ensureCapacity(int length) {
        if (this.capacity >= length) {
            return;
        }
        int lastIndex = length - 1;
        int segment = AdaptiveLongBigArray.segment(lastIndex);
        int offset = AdaptiveLongBigArray.offset(lastIndex);
        if (segment >= this.array.length) {
            int segmentsArrayCapacity;
            for (segmentsArrayCapacity = this.array.length; segment >= segmentsArrayCapacity; segmentsArrayCapacity *= 2) {
            }
            this.array = (long[][])Arrays.copyOf(this.array, segmentsArrayCapacity);
        }
        if (segment == 0) {
            if (this.array[0] == null) {
                this.array[0] = new long[16384];
            }
            if (offset >= this.array[0].length) {
                int segmentLength;
                for (segmentLength = this.array[0].length; offset >= segmentLength; segmentLength *= 2) {
                }
                this.array[0] = Arrays.copyOf(this.array[0], segmentLength);
            }
        } else {
            for (int i = 0; i <= segment; ++i) {
                if (this.array[i] == null) {
                    this.array[i] = new long[0x2000000];
                }
                if (i != 0 || this.array[0].length >= 0x2000000) continue;
                this.array[0] = Arrays.copyOf(this.array[0], 0x2000000);
            }
        }
        this.segments = segment + 1;
        this.capacity = this.segments == 1 ? this.array[0].length : 0x2000000 * this.segments;
    }

    private static int segment(int index) {
        return index >>> 25;
    }

    private static int offset(int index) {
        return index & 0x1FFFFFF;
    }

    public void clear() {
        this.array = new long[10][];
        this.segments = 0;
        this.capacity = 0;
    }
}

