/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.UncheckedBlock;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractType;
import com.facebook.presto.common.type.DistinctTypeInfo;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import io.airlift.slice.Slice;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DistinctType
extends AbstractType {
    private final QualifiedObjectName name;
    private final Type baseType;
    private final boolean isOrderable;
    private final Optional<QualifiedObjectName> parentTypeName;
    private Optional<DistinctType> lazilyLoadedParentType;
    private Optional<Function<QualifiedObjectName, DistinctType>> distinctTypeLoader;

    public DistinctType(DistinctTypeInfo distinctTypeInfo, Type baseType, Function<QualifiedObjectName, DistinctType> distinctTypeLoader) {
        this(distinctTypeInfo.getName(), baseType, distinctTypeInfo.isOrderable(), distinctTypeInfo.getTopMostAncestor(), new ArrayDeque<QualifiedObjectName>(distinctTypeInfo.getOtherAncestors()), distinctTypeLoader);
    }

    private DistinctType(QualifiedObjectName name, Type baseType, boolean isOrderable, Optional<QualifiedObjectName> topMostAncestor, Queue<QualifiedObjectName> otherAncestors, Function<QualifiedObjectName, DistinctType> distinctTypeLoader) {
        super(baseType.getJavaType());
        this.name = Objects.requireNonNull(name, "name is null");
        this.baseType = Objects.requireNonNull(baseType, "baseType is null");
        this.isOrderable = isOrderable;
        boolean rootTypeReached = otherAncestors.isEmpty();
        this.parentTypeName = rootTypeReached ? topMostAncestor : Optional.of(otherAncestors.poll());
        this.lazilyLoadedParentType = rootTypeReached ? Optional.empty() : Optional.of(new DistinctType(this.parentTypeName.get(), baseType, isOrderable, topMostAncestor, otherAncestors, distinctTypeLoader));
        this.distinctTypeLoader = this.parentTypeName.isPresent() ? Optional.of(Objects.requireNonNull(distinctTypeLoader, "distinctTypeLoader is null")) : Optional.empty();
    }

    public QualifiedObjectName getName() {
        return this.name;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Optional<DistinctType> getParentTypeLoadIfNeeded() {
        this.assureLoaded();
        return this.lazilyLoadedParentType;
    }

    public Optional<QualifiedObjectName> getParentTypeName() {
        return this.parentTypeName;
    }

    public static boolean hasAncestorRelationship(DistinctType firstType, DistinctType secondType) {
        Optional<DistinctType> lowestCommonSuperType = DistinctType.getLowestCommonSuperType(firstType, secondType);
        return lowestCommonSuperType.isPresent() && (lowestCommonSuperType.get().equals(firstType) || lowestCommonSuperType.get().equals(secondType));
    }

    public static Optional<DistinctType> getLowestCommonSuperType(DistinctType firstType, DistinctType secondType) {
        if (firstType.getBaseType() != secondType.getBaseType()) {
            return Optional.empty();
        }
        HashMap<QualifiedObjectName, DistinctType> seenTypes = new HashMap<QualifiedObjectName, DistinctType>();
        Optional<DistinctType> firstAncestor = Optional.of(firstType);
        Optional<DistinctType> secondAncestor = Optional.of(secondType);
        seenTypes.put(firstAncestor.get().getName(), firstAncestor.get());
        while (firstAncestor.get().lazilyLoadedParentType.isPresent()) {
            firstAncestor = firstAncestor.get().lazilyLoadedParentType;
            seenTypes.put(firstAncestor.get().getName(), firstAncestor.get());
        }
        if (seenTypes.containsKey(secondAncestor.get().getName())) {
            return secondAncestor;
        }
        seenTypes.put(secondAncestor.get().getName(), secondAncestor.get());
        while (secondAncestor.get().lazilyLoadedParentType.isPresent()) {
            secondAncestor = secondAncestor.get().lazilyLoadedParentType;
            if (seenTypes.containsKey(secondAncestor.get().getName())) {
                return secondAncestor;
            }
            seenTypes.put(secondAncestor.get().getName(), secondAncestor.get());
        }
        while (firstAncestor.get().getParentTypeName().isPresent() || secondAncestor.get().getParentTypeName().isPresent()) {
            if (firstAncestor.get().getParentTypeName().isPresent()) {
                if (seenTypes.containsKey(firstAncestor.get().getParentTypeName().get())) {
                    return Optional.of(seenTypes.get(firstAncestor.get().getParentTypeName().get()));
                }
                firstAncestor = firstAncestor.get().getParentTypeLoadIfNeeded();
                DistinctType.checkState(firstAncestor.isPresent(), "firstAncestor is empty");
                seenTypes.put(firstAncestor.get().getName(), firstAncestor.get());
            }
            if (!secondAncestor.get().getParentTypeName().isPresent()) continue;
            if (seenTypes.containsKey(secondAncestor.get().getParentTypeName().get())) {
                return Optional.of(seenTypes.get(secondAncestor.get().getParentTypeName().get()));
            }
            secondAncestor = secondAncestor.get().getParentTypeLoadIfNeeded();
            DistinctType.checkState(secondAncestor.isPresent(), "secondAncestor is empty");
            seenTypes.put(secondAncestor.get().getName(), secondAncestor.get());
        }
        return Optional.empty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DistinctType other = (DistinctType)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public TypeSignature getTypeSignature() {
        Optional<QualifiedObjectName> parentTypeName;
        ArrayList<QualifiedObjectName> ancestors = new ArrayList<QualifiedObjectName>();
        DistinctType type = this;
        while (true) {
            parentTypeName = type.getParentTypeName();
            if (!type.lazilyLoadedParentType.isPresent()) break;
            type = type.lazilyLoadedParentType.get();
            DistinctType.checkState(parentTypeName.isPresent(), "parentTypeName is empty");
            ancestors.add(parentTypeName.get());
        }
        Optional<QualifiedObjectName> lastAncestor = parentTypeName;
        return new TypeSignature(new DistinctTypeInfo(this.name, this.baseType.getTypeSignature(), lastAncestor, ancestors, this.isOrderable));
    }

    @Override
    public String getDisplayName() {
        return String.format("%s(%s)", this.name.toString(), this.baseType.getDisplayName());
    }

    @Override
    public boolean isComparable() {
        return this.baseType.isComparable();
    }

    @Override
    public boolean isOrderable() {
        return this.isOrderable;
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.baseType.getTypeParameters();
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return this.baseType.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.baseType.createBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        return this.baseType.getObjectValue(properties, block, position);
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        return this.baseType.getBoolean(block, position);
    }

    @Override
    public boolean getBooleanUnchecked(UncheckedBlock block, int internalPosition) {
        return this.baseType.getBooleanUnchecked(block, internalPosition);
    }

    @Override
    public long getLong(Block block, int position) {
        return this.baseType.getLong(block, position);
    }

    @Override
    public long getLongUnchecked(UncheckedBlock block, int internalPosition) {
        return this.baseType.getLongUnchecked(block, internalPosition);
    }

    @Override
    public double getDouble(Block block, int position) {
        return this.baseType.getDouble(block, position);
    }

    @Override
    public double getDoubleUnchecked(UncheckedBlock block, int internalPosition) {
        return this.baseType.getDoubleUnchecked(block, internalPosition);
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return this.baseType.getSlice(block, position);
    }

    @Override
    public Slice getSliceUnchecked(Block block, int internalPosition) {
        return this.baseType.getSliceUnchecked(block, internalPosition);
    }

    @Override
    public Object getObject(Block block, int position) {
        return this.baseType.getObject(block, position);
    }

    @Override
    public Block getBlockUnchecked(Block block, int internalPosition) {
        return this.baseType.getBlockUnchecked(block, internalPosition);
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        this.baseType.writeBoolean(blockBuilder, value);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        this.baseType.writeLong(blockBuilder, value);
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        this.baseType.writeDouble(blockBuilder, value);
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.baseType.writeSlice(blockBuilder, value);
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        this.baseType.writeSlice(blockBuilder, value, offset, length);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        this.baseType.writeObject(blockBuilder, value);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        this.baseType.appendTo(block, position, blockBuilder);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.baseType.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    @Override
    public long hash(Block block, int position) {
        return this.baseType.hash(block, position);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.baseType.compareTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    private void assureLoaded() {
        if (!this.distinctTypeLoader.isPresent()) {
            return;
        }
        this.loadParent();
    }

    private synchronized void loadParent() {
        if (!this.distinctTypeLoader.isPresent()) {
            return;
        }
        this.lazilyLoadedParentType = Optional.of(this.distinctTypeLoader.get().apply(this.parentTypeName.get()));
        this.distinctTypeLoader = Optional.empty();
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

