/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeUnit;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

@ThriftStruct
public class RuntimeStats {
    private final ConcurrentMap<String, RuntimeMetric> metrics = new ConcurrentHashMap<String, RuntimeMetric>();

    public RuntimeStats() {
    }

    @JsonCreator
    @ThriftConstructor
    public RuntimeStats(Map<String, RuntimeMetric> metrics) {
        Objects.requireNonNull(metrics, "metrics is null");
        metrics.forEach((name, newMetric) -> this.metrics.computeIfAbsent((String)name, k -> new RuntimeMetric((String)name, newMetric.getUnit())).mergeWith((RuntimeMetric)newMetric));
    }

    public static RuntimeStats copyOf(RuntimeStats stats) {
        return new RuntimeStats(stats.getMetrics());
    }

    public static RuntimeStats merge(RuntimeStats stats1, RuntimeStats stats2) {
        if (stats1 == null) {
            return stats2;
        }
        if (stats2 == null) {
            return stats1;
        }
        RuntimeStats mergedStats = RuntimeStats.copyOf(stats1);
        mergedStats.mergeWith(stats2);
        return mergedStats;
    }

    public void reset() {
        this.metrics.clear();
    }

    public RuntimeMetric getMetric(String name) {
        return (RuntimeMetric)this.metrics.get(name);
    }

    @JsonValue
    @ThriftField(value=1)
    public Map<String, RuntimeMetric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public void addMetricValue(String name, RuntimeUnit unit, long value) {
        this.metrics.computeIfAbsent(name, k -> new RuntimeMetric(name, unit)).addValue(value);
    }

    public void addMetricValueIgnoreZero(String name, RuntimeUnit unit, long value) {
        if (value == 0L) {
            return;
        }
        this.addMetricValue(name, unit, value);
    }

    public void mergeMetric(String name, RuntimeMetric metric) {
        this.metrics.computeIfAbsent(name, k -> new RuntimeMetric(name, metric.getUnit())).mergeWith(metric);
    }

    public void mergeWith(RuntimeStats stats) {
        if (stats == null) {
            return;
        }
        stats.getMetrics().forEach((name, newMetric) -> this.metrics.computeIfAbsent((String)name, k -> new RuntimeMetric((String)name, newMetric.getUnit())).mergeWith((RuntimeMetric)newMetric));
    }

    public void update(RuntimeStats stats) {
        if (stats == null) {
            return;
        }
        stats.getMetrics().forEach((name, newMetric) -> this.metrics.computeIfAbsent((String)name, k -> new RuntimeMetric((String)name, newMetric.getUnit())).set((RuntimeMetric)newMetric));
    }

    public <V> V profileNanos(String tag, Supplier<V> supplier) {
        long startTime = System.nanoTime();
        V result = supplier.get();
        this.addMetricValueIgnoreZero(tag, RuntimeUnit.NANO, System.nanoTime() - startTime);
        return result;
    }
}

