/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.TypeSignature;

public final class TimestampType
extends AbstractLongType {
    public static final TimestampType TIMESTAMP = new TimestampType();

    private TimestampType() {
        super(TypeSignature.parseTypeSignature("timestamp"));
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (properties.isLegacyTimestamp()) {
            return new SqlTimestamp(block.getLong(position), properties.getTimeZoneKey());
        }
        return new SqlTimestamp(block.getLong(position));
    }

    @Override
    public boolean equals(Object other) {
        return other == TIMESTAMP;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

