/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.AbstractMapBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ColumnarMap {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ColumnarMap.class).instanceSize();
    private final Block nullCheckBlock;
    private final int offsetsOffset;
    private final int[] offsets;
    private final Block keysBlock;
    private final Block valuesBlock;
    private final Type keyType;
    private final int[] hashTables;
    private final long retainedSizeInBytes;
    private final long estimatedSerializedSizeInBytes;

    public static ColumnarMap toColumnarMap(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return ColumnarMap.toColumnarMap((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarMap.toColumnarMap((RunLengthEncodedBlock)block);
        }
        if (!(block instanceof AbstractMapBlock)) {
            throw new IllegalArgumentException("Invalid map block: " + block.getClass().getName());
        }
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        int firstEntryPosition = mapBlock.getOffset(0);
        int totalEntryCount = mapBlock.getOffset(block.getPositionCount()) - firstEntryPosition;
        Block keysBlock = mapBlock.getRawKeyBlock().getRegion(firstEntryPosition, totalEntryCount);
        Block valuesBlock = mapBlock.getRawValueBlock().getRegion(firstEntryPosition, totalEntryCount);
        int[] hashTables = mapBlock.getHashTables().get();
        return new ColumnarMap(block, offsetBase, offsets, keysBlock, valuesBlock, mapBlock.keyType, hashTables, (long)INSTANCE_SIZE + block.getRetainedSizeInBytes(), block.getSizeInBytes());
    }

    private static ColumnarMap toColumnarMap(DictionaryBlock dictionaryBlock) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap(dictionaryBlock.getDictionary());
        int positionCount = dictionaryBlock.getPositionCount();
        int[] offsets = new int[positionCount + 1];
        for (int position = 0; position < positionCount; ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            offsets[position + 1] = offsets[position] + columnarMap.getEntryCount(dictionaryId);
        }
        int[] dictionaryIds = new int[offsets[positionCount]];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < positionCount; ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            int entryCount = columnarMap.getEntryCount(dictionaryId);
            int startOffset = columnarMap.getOffset(dictionaryId);
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                dictionaryIds[nextDictionaryIndex] = startOffset + entryIndex;
                ++nextDictionaryIndex;
            }
        }
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        return new ColumnarMap(dictionaryBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, keysBlock, dictionaryIds), new DictionaryBlock(dictionaryIds.length, valuesBlock, dictionaryIds), columnarMap.keyType, columnarMap.getHashTables(), (long)INSTANCE_SIZE + dictionaryBlock.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((int[])dictionaryIds), (long)(5 * positionCount) + (long)((keysBlock.getPositionCount() == 0 ? 0.0 : ((double)keysBlock.getSizeInBytes() / (double)keysBlock.getPositionCount() + (double)valuesBlock.getPositionCount() == 0.0 ? 0.0 : (double)valuesBlock.getSizeInBytes() / (double)valuesBlock.getPositionCount())) * (double)offsets[positionCount]));
    }

    private static ColumnarMap toColumnarMap(RunLengthEncodedBlock rleBlock) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap(rleBlock.getValue());
        int positionCount = rleBlock.getPositionCount();
        int[] offsets = new int[positionCount + 1];
        int entryCount = columnarMap.getEntryCount(0);
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i * entryCount;
        }
        int[] dictionaryIds = new int[positionCount * entryCount];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < positionCount; ++position) {
            int entryIndex = 0;
            while (entryIndex < entryCount) {
                dictionaryIds[nextDictionaryIndex] = entryIndex++;
                ++nextDictionaryIndex;
            }
        }
        Block keysBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        return new ColumnarMap(rleBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, keysBlock, dictionaryIds), new DictionaryBlock(dictionaryIds.length, valuesBlock, dictionaryIds), columnarMap.keyType, columnarMap.getHashTables(), (long)INSTANCE_SIZE + rleBlock.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((int[])dictionaryIds), (long)(5 * positionCount) + (long)(((double)keysBlock.getSizeInBytes() / (double)keysBlock.getPositionCount() + (double)valuesBlock.getSizeInBytes() / (double)valuesBlock.getPositionCount()) * (double)offsets[positionCount]));
    }

    private ColumnarMap(Block nullCheckBlock, int offsetsOffset, int[] offsets, Block keysBlock, Block valuesBlock, Type keyType, @Nullable int[] hashTables, long retainedSizeInBytes, long estimatedSerializedSizeInBytes) {
        this.nullCheckBlock = nullCheckBlock;
        this.offsetsOffset = offsetsOffset;
        this.offsets = offsets;
        this.keysBlock = keysBlock;
        this.valuesBlock = valuesBlock;
        this.keyType = keyType;
        this.hashTables = hashTables;
        this.retainedSizeInBytes = retainedSizeInBytes;
        this.estimatedSerializedSizeInBytes = estimatedSerializedSizeInBytes;
    }

    public int getPositionCount() {
        return this.nullCheckBlock.getPositionCount();
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock.isNull(position);
    }

    public int getEntryCount(int position) {
        return this.offsets[position + 1 + this.offsetsOffset] - this.offsets[position + this.offsetsOffset];
    }

    public int getOffset(int position) {
        return this.offsets[position + this.offsetsOffset] - this.offsets[this.offsetsOffset];
    }

    public int getAbsoluteOffset(int position) {
        return this.offsets[position + this.offsetsOffset];
    }

    public Block getKeysBlock() {
        return this.keysBlock;
    }

    public Block getValuesBlock() {
        return this.valuesBlock;
    }

    public Block getNullCheckBlock() {
        return this.nullCheckBlock;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    @Nullable
    public int[] getHashTables() {
        return this.hashTables;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public long getEstimatedSerializedSizeInBytes() {
        return this.estimatedSerializedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("positionCount=").append(this.getPositionCount()).append(",");
        sb.append("offsetsOffset=").append(this.offsetsOffset).append(",");
        sb.append("nullCheckBlock=").append(this.nullCheckBlock.toString()).append(",");
        sb.append("keysBlock=").append(this.keysBlock.toString()).append(",");
        sb.append("valuesBlock=").append(this.valuesBlock.toString()).append(",");
        sb.append("hashTablesSize=").append(this.hashTables == null ? 0 : this.hashTables.length).append(",");
        sb.append('}');
        return sb.toString();
    }
}

