/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.StageStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.NotNull;

@Immutable
public class StatementStats {
    private final String state;
    private final boolean scheduled;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long userTimeMillis;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final StageStats rootStage;

    @JsonCreator
    public StatementStats(@JsonProperty(value="state") String state, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="nodes") int nodes, @JsonProperty(value="totalSplits") int totalSplits, @JsonProperty(value="queuedSplits") int queuedSplits, @JsonProperty(value="runningSplits") int runningSplits, @JsonProperty(value="completedSplits") int completedSplits, @JsonProperty(value="userTimeMillis") long userTimeMillis, @JsonProperty(value="cpuTimeMillis") long cpuTimeMillis, @JsonProperty(value="wallTimeMillis") long wallTimeMillis, @JsonProperty(value="processedRows") long processedRows, @JsonProperty(value="processedBytes") long processedBytes, @JsonProperty(value="rootStage") StageStats rootStage) {
        this.state = (String)Preconditions.checkNotNull((Object)state, (Object)"state is null");
        this.scheduled = scheduled;
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.userTimeMillis = userTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.rootStage = rootStage;
    }

    @NotNull
    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public int getNodes() {
        return this.nodes;
    }

    @JsonProperty
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @JsonProperty
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @JsonProperty
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    public long getUserTimeMillis() {
        return this.userTimeMillis;
    }

    @JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    @JsonProperty
    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    @JsonProperty
    public long getProcessedRows() {
        return this.processedRows;
    }

    @JsonProperty
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @Nullable
    @JsonProperty
    public StageStats getRootStage() {
        return this.rootStage;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("scheduled", this.scheduled).add("nodes", this.nodes).add("totalSplits", this.totalSplits).add("queuedSplits", this.queuedSplits).add("runningSplits", this.runningSplits).add("completedSplits", this.completedSplits).add("userTimeMillis", this.userTimeMillis).add("cpuTimeMillis", this.cpuTimeMillis).add("wallTimeMillis", this.wallTimeMillis).add("processedRows", this.processedRows).add("processedBytes", this.processedBytes).add("rootStage", (Object)this.rootStage).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String state;
        private boolean scheduled;
        private int nodes;
        private int totalSplits;
        private int queuedSplits;
        private int runningSplits;
        private int completedSplits;
        private long userTimeMillis;
        private long cpuTimeMillis;
        private long wallTimeMillis;
        private long processedRows;
        private long processedBytes;
        private StageStats rootStage;

        private Builder() {
        }

        public Builder setState(String state) {
            this.state = (String)Preconditions.checkNotNull((Object)state, (Object)"state is null");
            return this;
        }

        public Builder setNodes(int nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder setScheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder setTotalSplits(int totalSplits) {
            this.totalSplits = totalSplits;
            return this;
        }

        public Builder setQueuedSplits(int queuedSplits) {
            this.queuedSplits = queuedSplits;
            return this;
        }

        public Builder setRunningSplits(int runningSplits) {
            this.runningSplits = runningSplits;
            return this;
        }

        public Builder setCompletedSplits(int completedSplits) {
            this.completedSplits = completedSplits;
            return this;
        }

        public Builder setUserTimeMillis(long userTimeMillis) {
            this.userTimeMillis = userTimeMillis;
            return this;
        }

        public Builder setCpuTimeMillis(long cpuTimeMillis) {
            this.cpuTimeMillis = cpuTimeMillis;
            return this;
        }

        public Builder setWallTimeMillis(long wallTimeMillis) {
            this.wallTimeMillis = wallTimeMillis;
            return this;
        }

        public Builder setProcessedRows(long processedRows) {
            this.processedRows = processedRows;
            return this;
        }

        public Builder setProcessedBytes(long processedBytes) {
            this.processedBytes = processedBytes;
            return this;
        }

        public Builder setRootStage(StageStats rootStage) {
            this.rootStage = rootStage;
            return this;
        }

        public StatementStats build() {
            return new StatementStats(this.state, this.scheduled, this.nodes, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.userTimeMillis, this.cpuTimeMillis, this.wallTimeMillis, this.processedRows, this.processedBytes, this.rootStage);
        }
    }
}

