/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Locale;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final String catalog;
    private final String schema;
    private final String timeZoneId;
    private final Locale locale;
    private final boolean debug;

    public static ClientSession withCatalog(ClientSession session, String catalog) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), catalog, session.getSchema(), session.getTimeZoneId(), session.getLocale(), session.isDebug());
    }

    public static ClientSession withSchema(ClientSession session, String schema) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getCatalog(), schema, session.getTimeZoneId(), session.getLocale(), session.isDebug());
    }

    public ClientSession(URI server, String user, String source, String catalog, String schema, String timeZoneId, Locale locale, boolean debug) {
        this.server = (URI)Preconditions.checkNotNull((Object)server, (Object)"server is null");
        this.user = user;
        this.source = source;
        this.catalog = catalog;
        this.schema = schema;
        this.locale = locale;
        this.timeZoneId = (String)Preconditions.checkNotNull((Object)timeZoneId, (Object)"timeZoneId is null");
        this.debug = debug;
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("server", (Object)this.server).add("user", (Object)this.user).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("timeZone", (Object)this.timeZoneId).add("locale", (Object)this.locale).add("debug", this.debug).toString();
    }
}

