/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client.auth.external;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.client.JsonResponse;
import com.facebook.presto.client.auth.external.Token;
import com.facebook.presto.client.auth.external.TokenPollResult;
import com.facebook.presto.client.auth.external.TokenPoller;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpTokenPoller
implements TokenPoller {
    private static final JsonCodec<TokenPollRepresentation> TOKEN_POLL_CODEC = JsonCodec.jsonCodec(TokenPollRepresentation.class);
    private static final String USER_AGENT_VALUE = "PrestoTokenPoller/" + (String)MoreObjects.firstNonNull((Object)HttpTokenPoller.class.getPackage().getImplementationVersion(), (Object)"unknown");
    private final Supplier<OkHttpClient> client;

    public HttpTokenPoller(OkHttpClient client) {
        Objects.requireNonNull(client, "client is null");
        this.client = () -> client;
    }

    public HttpTokenPoller(OkHttpClient client, Consumer<OkHttpClient.Builder> refreshableClientConfig) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(refreshableClientConfig, "refreshableClientConfig is null");
        this.client = () -> {
            OkHttpClient.Builder builder = client.newBuilder();
            refreshableClientConfig.accept(builder);
            return builder.build();
        };
    }

    @Override
    public TokenPollResult pollForToken(URI tokenUri, Duration timeout) {
        try {
            return (TokenPollResult)Failsafe.with((Policy)((RetryPolicy)new RetryPolicy().withMaxAttempts(-1).withMaxDuration(timeout).withBackoff(100L, 500L, ChronoUnit.MILLIS).handle(IOException.class)), (Policy[])new RetryPolicy[0]).get(() -> this.executePoll(HttpTokenPoller.prepareRequestBuilder(tokenUri).build()));
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof IOException) {
                throw new UncheckedIOException((IOException)e.getCause());
            }
            throw e;
        }
    }

    @Override
    public void tokenReceived(URI tokenUri) {
        try {
            Failsafe.with((Policy)((RetryPolicy)new RetryPolicy().withMaxAttempts(-1).withMaxDuration(Duration.ofSeconds(4L)).withBackoff(100L, 500L, ChronoUnit.MILLIS).handleResultIf(code -> code >= 500)), (Policy[])new RetryPolicy[0]).get(() -> {
                Request request = HttpTokenPoller.prepareRequestBuilder(tokenUri).delete().build();
                try (Response response = this.client.get().newCall(request).execute();){
                    Integer n = response.code();
                    return n;
                }
            });
        }
        catch (FailsafeException e) {
            if (e.getCause() instanceof IOException) {
                throw new UncheckedIOException((IOException)e.getCause());
            }
            throw e;
        }
    }

    private static Request.Builder prepareRequestBuilder(URI tokenUri) {
        HttpUrl url = HttpUrl.get((URI)tokenUri);
        if (url == null) {
            throw new IllegalArgumentException("Invalid token URI: " + tokenUri);
        }
        return new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT_VALUE);
    }

    private TokenPollResult executePoll(Request request) throws IOException {
        JsonResponse<TokenPollRepresentation> response = this.executeRequest(request);
        if (response.getStatusCode() == 200 && response.hasValue()) {
            return response.getValue().toResult();
        }
        Optional<String> responseBody = Optional.ofNullable(response.getResponseBody());
        String message = String.format("Request to %s failed: %s [Error: %s]", request.url(), response, responseBody.orElse("<Response Too Large>"));
        if (response.getStatusCode() == 503) {
            throw new IOException(message);
        }
        return TokenPollResult.failed(message);
    }

    private JsonResponse<TokenPollRepresentation> executeRequest(Request request) throws IOException {
        try {
            return JsonResponse.execute(TOKEN_POLL_CODEC, this.client.get(), request);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static class TokenPollRepresentation {
        private final String token;
        private final URI nextUri;
        private final String error;

        @JsonCreator
        public TokenPollRepresentation(@JsonProperty(value="token") String token, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="error") String error) {
            this.token = token;
            this.nextUri = nextUri;
            this.error = error;
        }

        TokenPollResult toResult() {
            if (this.token != null) {
                return TokenPollResult.successful(new Token(this.token));
            }
            if (this.error != null) {
                return TokenPollResult.failed(this.error);
            }
            if (this.nextUri != null) {
                return TokenPollResult.pending(this.nextUri);
            }
            return TokenPollResult.failed("Failed to poll for token. No fields set in response.");
        }
    }
}

