/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client.auth.external;

import com.facebook.presto.client.auth.external.CompositeRedirectHandler;
import com.facebook.presto.client.auth.external.DesktopBrowserRedirectHandler;
import com.facebook.presto.client.auth.external.RedirectHandler;
import com.facebook.presto.client.auth.external.SystemOpenRedirectHandler;
import com.facebook.presto.client.auth.external.SystemOutPrintRedirectHandler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public enum ExternalRedirectStrategy {
    DESKTOP_OPEN(new DesktopBrowserRedirectHandler()),
    SYSTEM_OPEN(new SystemOpenRedirectHandler()),
    PRINT(new SystemOutPrintRedirectHandler()),
    OPEN(new CompositeRedirectHandler((List<ExternalRedirectStrategy>)ImmutableList.of((Object)((Object)SYSTEM_OPEN), (Object)((Object)DESKTOP_OPEN)))),
    ALL(new CompositeRedirectHandler((List<ExternalRedirectStrategy>)ImmutableList.of((Object)((Object)OPEN), (Object)((Object)PRINT))));

    private final RedirectHandler handler;

    private ExternalRedirectStrategy(RedirectHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler is null");
    }

    public RedirectHandler getHandler() {
        return this.handler;
    }
}

