/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client.auth.external;

import com.facebook.presto.client.auth.external.RedirectException;
import com.facebook.presto.client.auth.external.RedirectHandler;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public final class DesktopBrowserRedirectHandler
implements RedirectHandler {
    @Override
    public void redirectTo(URI uri) throws RedirectException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            throw new RedirectException("Desktop Browser is not available. Make sure your Java process is not in headless mode (-Djava.awt.headless=false)");
        }
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            throw new RedirectException("Failed to redirect", e);
        }
    }
}

