/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client.auth.external;

import com.facebook.presto.client.ClientException;
import com.facebook.presto.client.auth.external.ExternalAuthentication;
import com.facebook.presto.client.auth.external.KnownToken;
import com.facebook.presto.client.auth.external.RedirectHandler;
import com.facebook.presto.client.auth.external.Token;
import com.facebook.presto.client.auth.external.TokenPoller;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class ExternalAuthenticator
implements Authenticator,
Interceptor {
    public static final String TOKEN_URI_FIELD = "x_token_server";
    public static final String REDIRECT_URI_FIELD = "x_redirect_server";
    private final TokenPoller tokenPoller;
    private final RedirectHandler redirectHandler;
    private final Duration timeout;
    private final KnownToken knownToken;

    public ExternalAuthenticator(RedirectHandler redirect, TokenPoller tokenPoller, KnownToken knownToken, Duration timeout) {
        this.tokenPoller = Objects.requireNonNull(tokenPoller, "tokenPoller is null");
        this.redirectHandler = Objects.requireNonNull(redirect, "redirect is null");
        this.knownToken = Objects.requireNonNull(knownToken, "knownToken is null");
        this.timeout = Objects.requireNonNull(timeout, "timeout is null");
    }

    @Nullable
    public Request authenticate(Route route, Response response) {
        this.knownToken.setupToken(() -> {
            Optional<ExternalAuthentication> authentication = ExternalAuthenticator.toAuthentication(response);
            if (!authentication.isPresent()) {
                return Optional.empty();
            }
            return authentication.get().obtainToken(this.timeout, this.redirectHandler, this.tokenPoller);
        });
        return this.knownToken.getToken().map(token -> ExternalAuthenticator.withBearerToken(response.request(), token)).orElse(null);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Optional<Token> token = this.knownToken.getToken();
        if (token.isPresent()) {
            return chain.proceed(ExternalAuthenticator.withBearerToken(chain.request(), token.get()));
        }
        return chain.proceed(chain.request());
    }

    private static Request withBearerToken(Request request, Token token) {
        return request.newBuilder().header("Authorization", "Bearer " + token.token()).build();
    }

    @VisibleForTesting
    static Optional<ExternalAuthentication> toAuthentication(Response response) {
        for (Challenge challenge : response.challenges()) {
            if (!challenge.scheme().equalsIgnoreCase("Bearer")) continue;
            Optional<URI> tokenUri = ExternalAuthenticator.parseField(challenge.authParams(), TOKEN_URI_FIELD);
            Optional<URI> redirectUri = ExternalAuthenticator.parseField(challenge.authParams(), REDIRECT_URI_FIELD);
            if (!tokenUri.isPresent()) continue;
            return Optional.of(new ExternalAuthentication(tokenUri.get(), redirectUri));
        }
        return Optional.empty();
    }

    private static Optional<URI> parseField(Map<String, String> fields, String key) {
        return Optional.ofNullable(fields.get(key)).map(value -> {
            try {
                return new URI((String)value);
            }
            catch (URISyntaxException e) {
                throw new ClientException(String.format("Failed to parse URI for field '%s'", key), e);
            }
        });
    }
}

