/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client.auth.external;

import com.facebook.presto.client.ClientException;
import com.facebook.presto.client.auth.external.RedirectHandler;
import com.facebook.presto.client.auth.external.Token;
import com.facebook.presto.client.auth.external.TokenPollResult;
import com.facebook.presto.client.auth.external.TokenPoller;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

class ExternalAuthentication {
    private final URI tokenUri;
    private final Optional<URI> redirectUri;

    public ExternalAuthentication(URI tokenUri, Optional<URI> redirectUri) {
        this.tokenUri = Objects.requireNonNull(tokenUri, "tokenUri is null");
        this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri is null");
    }

    public Optional<Token> obtainToken(Duration timeout, RedirectHandler handler, TokenPoller poller) {
        TokenPollResult result;
        this.redirectUri.ifPresent(handler::redirectTo);
        URI currentUri = this.tokenUri;
        long start = System.nanoTime();
        long timeoutNanos = timeout.toNanos();
        while (true) {
            long remaining;
            if ((remaining = timeoutNanos - (System.nanoTime() - start)) < 0L) {
                return Optional.empty();
            }
            result = poller.pollForToken(currentUri, Duration.ofNanos(remaining));
            if (result.isFailed()) {
                throw new ClientException(result.getError());
            }
            if (!result.isPending()) break;
            currentUri = result.getNextTokenUri();
        }
        poller.tokenReceived(currentUri);
        return Optional.of(result.getToken());
    }

    @VisibleForTesting
    Optional<URI> getRedirectUri() {
        return this.redirectUri;
    }

    @VisibleForTesting
    URI getTokenUri() {
        return this.tokenUri;
    }
}

