/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.Column;
import com.facebook.presto.client.FixJsonDataUtils;
import com.facebook.presto.client.QueryData;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryStatusInfo;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.spi.PrestoWarning;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public class QueryResults
implements QueryStatusInfo,
QueryData {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final Iterable<List<Object>> data;
    private final Iterable<String> binaryData;
    private final StatementStats stats;
    private final QueryError error;
    private final List<PrestoWarning> warnings;
    private final String updateType;
    private final Long updateCount;

    @JsonCreator
    public QueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="infoUri") URI infoUri, @JsonProperty(value="partialCancelUri") URI partialCancelUri, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="data") List<List<Object>> data, @JsonProperty(value="binaryData") List<String> binaryData, @JsonProperty(value="stats") StatementStats stats, @JsonProperty(value="error") QueryError error, @JsonProperty(value="warnings") List<PrestoWarning> warnings, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="updateCount") Long updateCount) {
        this(id, infoUri, partialCancelUri, nextUri, columns, FixJsonDataUtils.fixData(columns, data), binaryData, stats, error, (List<PrestoWarning>)((List)MoreObjects.firstNonNull(warnings, (Object)ImmutableList.of())), updateType, updateCount);
    }

    public QueryResults(String id, URI infoUri, URI partialCancelUri, URI nextUri, List<Column> columns, Iterable<List<Object>> data, Iterable<String> binaryData, StatementStats stats, QueryError error, List<PrestoWarning> warnings, String updateType, Long updateCount) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.infoUri = Objects.requireNonNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data != null ? Iterables.unmodifiableIterable(data) : null;
        this.binaryData = binaryData != null ? Iterables.unmodifiableIterable(binaryData) : null;
        Preconditions.checkArgument((data == null && binaryData == null || columns != null ? 1 : 0) != 0, (Object)"data present without columns");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.error = error;
        this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        this.updateType = updateType;
        this.updateCount = updateCount;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    @JsonProperty
    public Iterable<List<Object>> getData() {
        return this.data;
    }

    @Nullable
    @JsonProperty
    public Iterable<String> getBinaryData() {
        return this.binaryData;
    }

    @Override
    @JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Override
    @Nullable
    @JsonProperty
    public QueryError getError() {
        return this.error;
    }

    @Override
    @JsonProperty
    public List<PrestoWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @Override
    @Nullable
    @JsonProperty
    public Long getUpdateCount() {
        return this.updateCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("infoUri", (Object)this.infoUri).add("partialCancelUri", (Object)this.partialCancelUri).add("nextUri", (Object)this.nextUri).add("columns", this.columns).add("hasData", this.data != null).add("hasBinaryData", this.binaryData != null).add("stats", (Object)this.stats).add("error", (Object)this.error).add("updateType", (Object)this.updateType).add("updateCount", (Object)this.updateCount).toString();
    }
}

