/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.spi.security.SelectedRole;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final Optional<String> traceToken;
    private final Set<String> clientTags;
    private final String clientInfo;
    private final String catalog;
    private final String schema;
    private final TimeZoneKey timeZone;
    private final Locale locale;
    private final Map<String, String> resourceEstimates;
    private final Map<String, String> properties;
    private final Map<String, String> preparedStatements;
    private final Map<String, SelectedRole> roles;
    private final Map<String, String> extraCredentials;
    private final Map<String, String> customHeaders;
    private final String transactionId;
    private final Duration clientRequestTimeout;
    private final boolean compressionDisabled;
    private final Map<String, String> sessionFunctions;
    private final boolean validateNextUriSource;

    public static Builder builder(ClientSession clientSession) {
        return new Builder(clientSession);
    }

    public static ClientSession stripTransactionId(ClientSession session) {
        return ClientSession.builder(session).withoutTransactionId().build();
    }

    public ClientSession(URI server, String user, String source, Optional<String> traceToken, Set<String> clientTags, String clientInfo, String catalog, String schema, String timeZoneId, Locale locale, Map<String, String> resourceEstimates, Map<String, String> properties, Map<String, String> preparedStatements, Map<String, SelectedRole> roles, Map<String, String> extraCredentials, String transactionId, Duration clientRequestTimeout, boolean compressionDisabled, Map<String, String> sessionFunctions, Map<String, String> customHeaders, boolean validateNextUriSource) {
        this.server = Objects.requireNonNull(server, "server is null");
        this.user = user;
        this.source = source;
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientInfo = clientInfo;
        this.catalog = catalog;
        this.schema = schema;
        this.locale = locale;
        this.timeZone = TimeZoneKey.getTimeZoneKey((String)timeZoneId);
        this.transactionId = transactionId;
        this.resourceEstimates = ImmutableMap.copyOf(Objects.requireNonNull(resourceEstimates, "resourceEstimates is null"));
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.preparedStatements = ImmutableMap.copyOf(Objects.requireNonNull(preparedStatements, "preparedStatements is null"));
        this.roles = ImmutableMap.copyOf(Objects.requireNonNull(roles, "roles is null"));
        this.extraCredentials = ImmutableMap.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
        this.customHeaders = ImmutableMap.copyOf(Objects.requireNonNull(customHeaders, "customHeaders is null"));
        this.clientRequestTimeout = clientRequestTimeout;
        this.compressionDisabled = compressionDisabled;
        this.sessionFunctions = ImmutableMap.copyOf(Objects.requireNonNull(sessionFunctions, "sessionFunctions is null"));
        this.validateNextUriSource = validateNextUriSource;
        for (String clientTag : clientTags) {
            Preconditions.checkArgument((!clientTag.contains(",") ? 1 : 0) != 0, (Object)"client tag cannot contain ','");
        }
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (Map.Entry<String, String> entry : resourceEstimates.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Resource name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Resource name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Resource name is not US_ASCII: %s", (Object)entry.getKey());
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Session property name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getValue()), (String)"Session property value is not US_ASCII: %s", (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : extraCredentials.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Credential name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Credential name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Credential name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getValue()), (String)"Credential value is not US_ASCII: %s", (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Custom header name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Custom header must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Custom header name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getValue()), (String)"Custom header value is not US_ASCII: %s", (Object)entry.getValue());
        }
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Map<String, SelectedRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isDebug() {
        return false;
    }

    public Duration getClientRequestTimeout() {
        return this.clientRequestTimeout;
    }

    public boolean isCompressionDisabled() {
        return this.compressionDisabled;
    }

    public Map<String, String> getSessionFunctions() {
        return this.sessionFunctions;
    }

    public boolean validateNextUriSource() {
        return this.validateNextUriSource;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.server).add("user", (Object)this.user).add("clientTags", this.clientTags).add("clientInfo", (Object)this.clientInfo).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("traceToken", this.traceToken.orElse(null)).add("timeZone", (Object)this.timeZone).add("locale", (Object)this.locale).add("properties", this.properties).add("transactionId", (Object)this.transactionId).omitNullValues().toString();
    }

    public static final class Builder {
        private URI server;
        private String user;
        private String source;
        private Optional<String> traceToken;
        private Set<String> clientTags;
        private String clientInfo;
        private String catalog;
        private String schema;
        private TimeZoneKey timeZone;
        private Locale locale;
        private Map<String, String> resourceEstimates;
        private Map<String, String> properties;
        private Map<String, String> preparedStatements;
        private Map<String, SelectedRole> roles;
        private Map<String, String> credentials;
        private Map<String, String> customHeaders;
        private String transactionId;
        private Duration clientRequestTimeout;
        private boolean compressionDisabled;
        private Map<String, String> sessionFunctions;
        private boolean validateNextUriSource;

        private Builder(ClientSession clientSession) {
            Objects.requireNonNull(clientSession, "clientSession is null");
            this.server = clientSession.getServer();
            this.user = clientSession.getUser();
            this.source = clientSession.getSource();
            this.traceToken = clientSession.getTraceToken();
            this.clientTags = clientSession.getClientTags();
            this.clientInfo = clientSession.getClientInfo();
            this.catalog = clientSession.getCatalog();
            this.schema = clientSession.getSchema();
            this.timeZone = clientSession.getTimeZone();
            this.locale = clientSession.getLocale();
            this.resourceEstimates = clientSession.getResourceEstimates();
            this.properties = clientSession.getProperties();
            this.preparedStatements = clientSession.getPreparedStatements();
            this.roles = clientSession.getRoles();
            this.credentials = clientSession.getExtraCredentials();
            this.customHeaders = clientSession.getCustomHeaders();
            this.transactionId = clientSession.getTransactionId();
            this.clientRequestTimeout = clientSession.getClientRequestTimeout();
            this.compressionDisabled = clientSession.isCompressionDisabled();
            this.sessionFunctions = clientSession.getSessionFunctions();
            this.validateNextUriSource = clientSession.validateNextUriSource();
        }

        public Builder withCatalog(String catalog) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            return this;
        }

        public Builder withSchema(String schema) {
            this.schema = Objects.requireNonNull(schema, "schema is null");
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = Objects.requireNonNull(properties, "properties is null");
            return this;
        }

        public Builder withRoles(Map<String, SelectedRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withCredentials(Map<String, String> credentials) {
            this.credentials = Objects.requireNonNull(credentials, "extraCredentials is null");
            return this;
        }

        public Builder withCustomHeaders(Map<String, String> customHeaders) {
            this.customHeaders = Objects.requireNonNull(customHeaders, "customHeaders is null");
            return this;
        }

        public Builder withPreparedStatements(Map<String, String> preparedStatements) {
            this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
            return this;
        }

        public Builder withoutTransactionId() {
            this.transactionId = null;
            return this;
        }

        public Builder withCompressionDisabled(boolean compressionDisabled) {
            this.compressionDisabled = compressionDisabled;
            return this;
        }

        public Builder withSessionFunctions(Map<String, String> sessionFunctions) {
            this.sessionFunctions = Objects.requireNonNull(sessionFunctions, "sessionFunctions is null");
            return this;
        }

        public Builder withValidateNextUriSource(boolean validateNextUriSource) {
            this.validateNextUriSource = validateNextUriSource;
            return this;
        }

        public ClientSession build() {
            return new ClientSession(this.server, this.user, this.source, this.traceToken, this.clientTags, this.clientInfo, this.catalog, this.schema, this.timeZone.getId(), this.locale, this.resourceEstimates, this.properties, this.preparedStatements, this.roles, this.credentials, this.transactionId, this.clientRequestTimeout, this.compressionDisabled, this.sessionFunctions, this.customHeaders, this.validateNextUriSource);
        }
    }
}

