/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.ClientTypeSignature;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Column {
    private final String name;
    private final String type;
    private final ClientTypeSignature typeSignature;

    public Column(String name, Type type) {
        this(name, type.getTypeSignature());
    }

    public Column(String name, TypeSignature signature) {
        this(name, signature.toString(), new ClientTypeSignature(signature));
    }

    @JsonCreator
    public Column(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="typeSignature") ClientTypeSignature typeSignature) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.typeSignature = typeSignature;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public ClientTypeSignature getTypeSignature() {
        return this.typeSignature;
    }
}

