/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.spi.type.TimeZoneKey;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClientSession {
    private final URI server;
    private final String user;
    private final String source;
    private final Set<String> clientTags;
    private final String clientInfo;
    private final String catalog;
    private final String schema;
    private final TimeZoneKey timeZone;
    private final Locale locale;
    private final Map<String, String> properties;
    private final Map<String, String> preparedStatements;
    private final String transactionId;
    private final Duration clientRequestTimeout;

    public static ClientSession withCatalogAndSchema(ClientSession session, String catalog, String schema) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), catalog, schema, session.getTimeZone().getId(), session.getLocale(), session.getProperties(), session.getPreparedStatements(), session.getTransactionId(), session.getClientRequestTimeout());
    }

    public static ClientSession withProperties(ClientSession session, Map<String, String> properties) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), properties, session.getPreparedStatements(), session.getTransactionId(), session.getClientRequestTimeout());
    }

    public static ClientSession withPreparedStatements(ClientSession session, Map<String, String> preparedStatements) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), session.getProperties(), preparedStatements, session.getTransactionId(), session.getClientRequestTimeout());
    }

    public static ClientSession withTransactionId(ClientSession session, String transactionId) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), session.getProperties(), session.getPreparedStatements(), transactionId, session.getClientRequestTimeout());
    }

    public static ClientSession stripTransactionId(ClientSession session) {
        return new ClientSession(session.getServer(), session.getUser(), session.getSource(), session.getClientTags(), session.getClientInfo(), session.getCatalog(), session.getSchema(), session.getTimeZone().getId(), session.getLocale(), session.getProperties(), session.getPreparedStatements(), null, session.getClientRequestTimeout());
    }

    public ClientSession(URI server, String user, String source, Set<String> clientTags, String clientInfo, String catalog, String schema, String timeZoneId, Locale locale, Map<String, String> properties, Map<String, String> preparedStatements, String transactionId, Duration clientRequestTimeout) {
        this.server = Objects.requireNonNull(server, "server is null");
        this.user = user;
        this.source = source;
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientInfo = clientInfo;
        this.catalog = catalog;
        this.schema = schema;
        this.locale = locale;
        this.timeZone = TimeZoneKey.getTimeZoneKey((String)timeZoneId);
        this.transactionId = transactionId;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.preparedStatements = ImmutableMap.copyOf(Objects.requireNonNull(preparedStatements, "preparedStatements is null"));
        this.clientRequestTimeout = clientRequestTimeout;
        for (String clientTag : clientTags) {
            Preconditions.checkArgument((!clientTag.contains(",") ? 1 : 0) != 0, (Object)"client tag cannot contain ','");
        }
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument((!entry.getKey().isEmpty() ? 1 : 0) != 0, (Object)"Session property name is empty");
            Preconditions.checkArgument((entry.getKey().indexOf(61) < 0 ? 1 : 0) != 0, (String)"Session property name must not contain '=': %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getKey()), (String)"Session property name is not US_ASCII: %s", (Object)entry.getKey());
            Preconditions.checkArgument((boolean)charsetEncoder.canEncode(entry.getValue()), (String)"Session property value is not US_ASCII: %s", (Object)entry.getValue());
        }
    }

    public URI getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public String getSource() {
        return this.source;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isDebug() {
        return false;
    }

    public Duration getClientRequestTimeout() {
        return this.clientRequestTimeout;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.server).add("user", (Object)this.user).add("clientTags", this.clientTags).add("clientInfo", (Object)this.clientInfo).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("timeZone", (Object)this.timeZone).add("locale", (Object)this.locale).add("properties", this.properties).add("transactionId", (Object)this.transactionId).toString();
    }
}

