/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.client;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StatementClient
implements Closeable {
    private static final Splitter SESSION_HEADER_SPLITTER = Splitter.on((char)'=').limit(2).trimResults();
    private static final String USER_AGENT_VALUE = StatementClient.class.getSimpleName() + "/" + (String)MoreObjects.firstNonNull((Object)StatementClient.class.getPackage().getImplementationVersion(), (Object)"unknown");
    private final HttpClient httpClient;
    private final FullJsonResponseHandler<QueryResults> responseHandler;
    private final boolean debug;
    private final String query;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean gone = new AtomicBoolean();
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final String timeZoneId;
    private final long requestTimeoutNanos;

    public StatementClient(HttpClient httpClient, JsonCodec<QueryResults> queryResultsCodec, ClientSession session, String query) {
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(queryResultsCodec, "queryResultsCodec is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        this.httpClient = httpClient;
        this.responseHandler = FullJsonResponseHandler.createFullJsonResponseHandler(queryResultsCodec);
        this.debug = session.isDebug();
        this.timeZoneId = session.getTimeZoneId();
        this.query = query;
        this.requestTimeoutNanos = session.getClientRequestTimeout().roundTo(TimeUnit.NANOSECONDS);
        Request request = StatementClient.buildQueryRequest(session, query);
        FullJsonResponseHandler.JsonResponse response = (FullJsonResponseHandler.JsonResponse)httpClient.execute(request, this.responseHandler);
        if (response.getStatusCode() != HttpStatus.OK.code() || !response.hasValue()) {
            throw this.requestFailedException("starting query", request, (FullJsonResponseHandler.JsonResponse<QueryResults>)response);
        }
        this.processResponse((FullJsonResponseHandler.JsonResponse<QueryResults>)response);
    }

    private static Request buildQueryRequest(ClientSession session, String query) {
        Request.Builder builder = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)session.getServer()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8));
        if (session.getUser() != null) {
            builder.setHeader("X-Presto-User", session.getUser());
        }
        if (session.getSource() != null) {
            builder.setHeader("X-Presto-Source", session.getSource());
        }
        if (session.getCatalog() != null) {
            builder.setHeader("X-Presto-Catalog", session.getCatalog());
        }
        if (session.getSchema() != null) {
            builder.setHeader("X-Presto-Schema", session.getSchema());
        }
        builder.setHeader("X-Presto-Time-Zone", session.getTimeZoneId());
        builder.setHeader("X-Presto-Language", session.getLocale().toLanguageTag());
        builder.setHeader("User-Agent", USER_AGENT_VALUE);
        Map<String, String> property = session.getProperties();
        for (Map.Entry<String, String> entry : property.entrySet()) {
            builder.addHeader("X-Presto-Session", entry.getKey() + "=" + entry.getValue());
        }
        return builder.build();
    }

    public String getQuery() {
        return this.query;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isGone() {
        return this.gone.get();
    }

    public boolean isFailed() {
        return this.currentResults.get().getError() != null;
    }

    public StatementStats getStats() {
        return this.currentResults.get().getStats();
    }

    public QueryResults current() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    public QueryResults finalResults() {
        Preconditions.checkState((!this.isValid() || this.isFailed() ? 1 : 0) != 0, (Object)"current position is still valid");
        return this.currentResults.get();
    }

    public Map<String, String> getSetSessionProperties() {
        return ImmutableMap.copyOf(this.setSessionProperties);
    }

    public Set<String> getResetSessionProperties() {
        return ImmutableSet.copyOf(this.resetSessionProperties);
    }

    public boolean isValid() {
        return this.valid.get() && !this.isGone() && !this.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advance() {
        URI nextUri = this.current().getNextUri();
        if (this.isClosed() || nextUri == null) {
            this.valid.set(false);
            return false;
        }
        Request request = Request.Builder.prepareGet().setHeader("User-Agent", USER_AGENT_VALUE).setUri(nextUri).build();
        RuntimeException cause = null;
        long start = System.nanoTime();
        long attempts = 0L;
        do {
            FullJsonResponseHandler.JsonResponse response;
            if (attempts > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                }
                catch (InterruptedException e) {
                    try {
                        this.close();
                    }
                    finally {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException("StatementClient thread was interrupted");
                }
            }
            ++attempts;
            try {
                response = (FullJsonResponseHandler.JsonResponse)this.httpClient.execute(request, this.responseHandler);
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                this.processResponse((FullJsonResponseHandler.JsonResponse<QueryResults>)response);
                return true;
            }
            if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) continue;
            throw this.requestFailedException("fetching next", request, (FullJsonResponseHandler.JsonResponse<QueryResults>)response);
        } while (System.nanoTime() - start < this.requestTimeoutNanos && !this.isClosed());
        this.gone.set(true);
        throw new RuntimeException("Error fetching next", cause);
    }

    private void processResponse(FullJsonResponseHandler.JsonResponse<QueryResults> response) {
        for (String setSession : response.getHeaders().get((Object)"X-Presto-Set-Session")) {
            List keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)setSession);
            if (keyValue.size() != 2) continue;
            this.setSessionProperties.put((String)keyValue.get(0), keyValue.size() > 1 ? (String)keyValue.get(1) : "");
        }
        for (String clearSession : response.getHeaders().get((Object)"X-Presto-Clear-Session")) {
            this.resetSessionProperties.add(clearSession);
        }
        this.currentResults.set((QueryResults)response.getValue());
    }

    private RuntimeException requestFailedException(String task, Request request, FullJsonResponseHandler.JsonResponse<QueryResults> response) {
        this.gone.set(true);
        if (!response.hasValue()) {
            return new RuntimeException(String.format("Error %s at %s returned an invalid response: %s [Error: %s]", task, request.getUri(), response, response.getResponseBody()), response.getException());
        }
        return new RuntimeException(String.format("Error %s at %s returned %s: %s", task, request.getUri(), response.getStatusCode(), response.getStatusMessage()));
    }

    public boolean cancelLeafStage(Duration timeout) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"client is closed");
        URI uri = this.current().getPartialCancelUri();
        if (uri == null) {
            return false;
        }
        Request request = Request.Builder.prepareDelete().setHeader("User-Agent", USER_AGENT_VALUE).setUri(uri).build();
        HttpClient.HttpResponseFuture response = this.httpClient.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        try {
            StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)response.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return HttpStatus.familyForStatusCode((int)status.getStatusCode()) == HttpStatus.Family.SUCCESSFUL;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public void close() {
        URI uri;
        if (!this.closed.getAndSet(true) && (uri = this.currentResults.get().getNextUri()) != null) {
            Request request = Request.Builder.prepareDelete().setHeader("User-Agent", USER_AGENT_VALUE).setUri(uri).build();
            this.httpClient.executeAsync(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        }
    }
}

