/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.QueryRunner;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jline.console.completer.Completer;

public class TableNameCompleter
implements Completer,
Closeable {
    private static final long RELOAD_TIME_MINUTES = 2L;
    private final ExecutorService executor = Executors.newCachedThreadPool(TableNameCompleter.daemonThreadsNamed("completer-%d"));
    private final ClientSession clientSession;
    private final QueryRunner queryRunner;
    private final LoadingCache<String, List<String>> tableCache;
    private final LoadingCache<String, List<String>> functionCache;

    public TableNameCompleter(ClientSession clientSession, QueryRunner queryRunner) {
        this.clientSession = (ClientSession)Preconditions.checkNotNull((Object)clientSession, (Object)"clientSession was null!");
        this.queryRunner = (QueryRunner)Preconditions.checkNotNull((Object)queryRunner, (Object)"queryRunner session was null!");
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)this.executor);
        this.tableCache = CacheBuilder.newBuilder().refreshAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String schemaName) {
                return TableNameCompleter.this.queryMetadata(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName));
            }
        });
        this.functionCache = CacheBuilder.newBuilder().build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String schemaName) {
                return TableNameCompleter.this.queryMetadata("SHOW FUNCTIONS");
            }
        });
    }

    private List<String> queryMetadata(String query) {
        ImmutableList.Builder cache = ImmutableList.builder();
        try (StatementClient client = this.queryRunner.startInternalQuery(query);){
            while (client.isValid() && !Thread.currentThread().isInterrupted()) {
                QueryResults results = client.current();
                if (results.getData() != null) {
                    for (List row : results.getData()) {
                        cache.add((Object)((String)row.get(0)));
                    }
                }
                client.advance();
            }
        }
        return cache.build();
    }

    public void populateCache(final String schemaName) {
        Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TableNameCompleter.this.functionCache.refresh((Object)schemaName);
                TableNameCompleter.this.tableCache.refresh((Object)schemaName);
            }
        });
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (cursor <= 0) {
            return cursor;
        }
        int blankPos = this.findLastBlank(buffer.substring(0, cursor));
        String prefix = buffer.substring(blankPos + 1, cursor);
        String schemaName = this.clientSession.getSchema();
        List functionNames = (List)this.functionCache.getIfPresent((Object)schemaName);
        List tableNames = (List)this.tableCache.getIfPresent((Object)schemaName);
        TreeSet<String> sortedCandidates = new TreeSet<String>();
        if (functionNames != null) {
            sortedCandidates.addAll(TableNameCompleter.filterResults(functionNames, prefix));
        }
        if (tableNames != null) {
            sortedCandidates.addAll(TableNameCompleter.filterResults(tableNames, prefix));
        }
        candidates.addAll(sortedCandidates);
        return blankPos + 1;
    }

    private int findLastBlank(String buffer) {
        for (int i = buffer.length() - 1; i >= 0; --i) {
            if (!Character.isWhitespace(buffer.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static List<String> filterResults(List<String> values, String prefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : values) {
            if (!value.startsWith(prefix)) continue;
            builder.add((Object)value);
        }
        return builder.build();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    private static ThreadFactory daemonThreadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).build();
    }

    static abstract class BackgroundCacheLoader<K, V>
    extends CacheLoader<K, V> {
        private final ListeningExecutorService executor;

        protected BackgroundCacheLoader(ListeningExecutorService executor) {
            this.executor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        }

        public final ListenableFuture<V> reload(final K key, V oldValue) {
            return this.executor.submit(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return BackgroundCacheLoader.this.load(key);
                }
            });
        }
    }
}

