/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.AlignedTablePrinter;
import com.facebook.presto.cli.OutputPrinter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class JsonPrinter
implements OutputPrinter {
    private final List<String> fieldNames;
    private final Writer writer;

    public JsonPrinter(List<String> fieldNames, Writer writer) {
        this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
        this.writer = Objects.requireNonNull(writer, "writer is null");
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        for (List<?> row : rows) {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator(this.writer);
            jsonGenerator.writeStartObject();
            for (int position = 0; position < row.size(); ++position) {
                String columnName = this.fieldNames.get(position);
                jsonGenerator.writeObjectField(columnName, JsonPrinter.formatValue(row.get(position)));
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeRaw('\n');
            jsonGenerator.flush();
        }
    }

    @Override
    public void finish() throws IOException {
        this.writer.flush();
    }

    private static Object formatValue(Object o) {
        if (o instanceof byte[]) {
            return AlignedTablePrinter.formatHexDump((byte[])o);
        }
        return o;
    }
}

