/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.ConsolePrinter;
import com.facebook.presto.cli.FormatUtils;
import com.facebook.presto.cli.KeyReader;
import com.facebook.presto.client.QueryStatusInfo;
import com.facebook.presto.client.StageStats;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.client.StatementStats;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StatusPrinter {
    private static final Logger log = Logger.get(StatusPrinter.class);
    private static final int CTRL_C = 3;
    private static final int CTRL_P = 16;
    private final long start = System.nanoTime();
    private final StatementClient client;
    private final PrintStream out;
    private final ConsolePrinter console;
    private boolean debug;

    public StatusPrinter(StatementClient client, PrintStream out, boolean debug) {
        this.client = client;
        this.out = out;
        this.console = new ConsolePrinter(out);
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printInitialStatusUpdates() {
        long lastPrint = System.nanoTime();
        try {
            while (this.client.isRunning()) {
                block14: {
                    if (this.client.currentData().getData() == null) break block14;
                    return;
                }
                try {
                    boolean update = Duration.nanosSince((long)lastPrint).getValue(TimeUnit.SECONDS) >= 0.5;
                    int key = KeyReader.readKey();
                    if (key == 16) {
                        this.client.cancelLeafStage();
                    } else if (key == 3) {
                        this.updateScreen();
                        update = false;
                        this.client.close();
                    } else if (Character.toUpperCase(key) == 68) {
                        this.debug = !this.debug;
                        this.console.resetScreen();
                        update = true;
                    }
                    if (update) {
                        this.updateScreen();
                        lastPrint = System.nanoTime();
                    }
                    this.client.advance();
                }
                catch (RuntimeException e) {
                    log.debug((Throwable)e, "error printing status");
                    if (!this.debug) continue;
                    e.printStackTrace(this.out);
                }
            }
        }
        finally {
            this.console.resetScreen();
        }
    }

    private void updateScreen() {
        this.console.repositionCursor();
        this.printQueryInfo(this.client.currentStatusInfo());
    }

    public void printFinalInfo() {
        Duration wallTime = Duration.nanosSince((long)this.start);
        QueryStatusInfo results = this.client.finalStatusInfo();
        StatementStats stats = results.getStats();
        int nodes = stats.getNodes();
        if (nodes == 0 || stats.getTotalSplits() == 0) {
            return;
        }
        this.out.println();
        String querySummary = String.format("Query %s, %s, %,d %s", results.getId(), stats.getState(), nodes, FormatUtils.pluralize("node", nodes));
        this.out.println(querySummary);
        if (this.debug) {
            this.out.println(results.getInfoUri().toString());
        }
        String splitsSummary = String.format("Splits: %,d total, %,d done (%.2f%%)", stats.getTotalSplits(), stats.getCompletedSplits(), stats.getProgressPercentage().orElse(0.0));
        this.out.println(splitsSummary);
        if (this.debug) {
            Duration cpuTime = StatusPrinter.millis(stats.getCpuTimeMillis());
            String cpuTimeSummary = String.format("CPU Time: %.1fs total, %5s rows/s, %8s, %d%% active", cpuTime.getValue(TimeUnit.SECONDS), FormatUtils.formatCountRate(stats.getProcessedRows(), cpuTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), cpuTime, true), (int)StatusPrinter.percentage(stats.getCpuTimeMillis(), stats.getWallTimeMillis()));
            this.out.println(cpuTimeSummary);
            double parallelism = cpuTime.getValue(TimeUnit.MILLISECONDS) / wallTime.getValue(TimeUnit.MILLISECONDS);
            String perNodeSummary = String.format("Per Node: %.1f parallelism, %5s rows/s, %8s", parallelism / (double)nodes, FormatUtils.formatCountRate((double)stats.getProcessedRows() / (double)nodes, wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes() / (long)nodes), wallTime, true));
            this.reprintLine(perNodeSummary);
            this.out.println(String.format("Parallelism: %.1f", parallelism));
            this.reprintLine("Peak Memory: " + FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getPeakMemoryBytes()), true));
        }
        String statsLine = String.format("%s [%s rows, %s] [%s rows/s, %s]", FormatUtils.formatTime(wallTime), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), true), FormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, true));
        this.out.println(statsLine);
        this.out.println();
    }

    private void printQueryInfo(QueryStatusInfo results) {
        StatementStats stats = results.getStats();
        Duration wallTime = Duration.nanosSince((long)this.start);
        int progressPercentage = (int)Math.min(99.0, stats.getProgressPercentage().orElse(0.0));
        if (this.console.isRealTerminal()) {
            String progressLine;
            String progressBar;
            this.reprintLine("");
            int terminalWidth = this.console.getWidth();
            if (terminalWidth < 75) {
                this.reprintLine("WARNING: Terminal");
                this.reprintLine("must be at least");
                this.reprintLine("80 characters wide");
                this.reprintLine("");
                this.reprintLine(stats.getState());
                this.reprintLine(String.format("%s %d%%", FormatUtils.formatTime(wallTime), progressPercentage));
                return;
            }
            int nodes = stats.getNodes();
            String querySummary = String.format("Query %s, %s, %,d %s, %,d splits", results.getId(), stats.getState(), nodes, FormatUtils.pluralize("node", nodes), stats.getTotalSplits());
            this.reprintLine(querySummary);
            String url = results.getInfoUri().toString();
            if (this.debug && url.length() < terminalWidth) {
                this.reprintLine(url);
            }
            if (nodes == 0 || stats.getTotalSplits() == 0) {
                return;
            }
            if (this.debug) {
                String splitsSummary = String.format("Splits:   %,d queued, %,d running, %,d done", stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits());
                this.reprintLine(splitsSummary);
                Duration cpuTime = StatusPrinter.millis(stats.getCpuTimeMillis());
                String cpuTimeSummary = String.format("CPU Time: %.1fs total, %5s rows/s, %8s, %d%% active", cpuTime.getValue(TimeUnit.SECONDS), FormatUtils.formatCountRate(stats.getProcessedRows(), cpuTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), cpuTime, true), (int)StatusPrinter.percentage(stats.getCpuTimeMillis(), stats.getWallTimeMillis()));
                this.reprintLine(cpuTimeSummary);
                double parallelism = cpuTime.getValue(TimeUnit.MILLISECONDS) / wallTime.getValue(TimeUnit.MILLISECONDS);
                String perNodeSummary = String.format("Per Node: %.1f parallelism, %5s rows/s, %8s", parallelism / (double)nodes, FormatUtils.formatCountRate((double)stats.getProcessedRows() / (double)nodes, wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes() / (long)nodes), wallTime, true));
                this.reprintLine(perNodeSummary);
                this.reprintLine(String.format("Parallelism: %.1f", parallelism));
                this.reprintLine("Peak Memory: " + FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getPeakMemoryBytes()), true));
            }
            Verify.verify((terminalWidth >= 75 ? 1 : 0) != 0);
            int progressWidth = Math.min(terminalWidth, 100) - 75 + 17;
            if (stats.isScheduled()) {
                progressBar = FormatUtils.formatProgressBar(progressWidth, stats.getCompletedSplits(), Math.max(0, stats.getRunningSplits()), stats.getTotalSplits());
                progressLine = String.format("%s [%5s rows, %6s] [%5s rows/s, %8s] [%s] %d%%", FormatUtils.formatTime(wallTime), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), true), FormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, true), progressBar, progressPercentage);
                this.reprintLine(progressLine);
            } else {
                progressBar = FormatUtils.formatProgressBar(progressWidth, Ints.saturatedCast((long)Duration.nanosSince((long)this.start).roundTo(TimeUnit.SECONDS)));
                progressLine = String.format("%s [%5s rows, %6s] [%5s rows/s, %8s] [%s]", FormatUtils.formatTime(wallTime), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), true), FormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, true), progressBar);
                this.reprintLine(progressLine);
            }
            this.reprintLine("");
            String stagesHeader = String.format("%10s%1s  %5s  %6s  %5s  %7s  %6s  %5s  %5s", "STAGE", "S", "ROWS", "ROWS/s", "BYTES", "BYTES/s", "QUEUED", "RUN", "DONE");
            this.reprintLine(stagesHeader);
            this.printStageTree(stats.getRootStage(), "", new AtomicInteger());
        } else {
            String querySummary = String.format("Query %s [%s] i[%s %s %s] o[%s %s %s] splits[%,d/%,d/%,d]", results.getId(), stats.getState(), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, false), FormatUtils.formatCount(stats.getProcessedRows()), FormatUtils.formatDataSize(StatusPrinter.bytes(stats.getProcessedBytes()), false), FormatUtils.formatDataRate(StatusPrinter.bytes(stats.getProcessedBytes()), wallTime, false), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits());
            this.reprintLine(querySummary);
        }
    }

    private void printStageTree(StageStats stage, String indent, AtomicInteger stageNumberCounter) {
        String rowsPerSecond;
        String bytesPerSecond;
        Duration elapsedTime = Duration.nanosSince((long)this.start);
        String id = String.valueOf(stageNumberCounter.getAndIncrement());
        String name = indent + id;
        name = name + Strings.repeat((String)".", (int)Math.max(0, 10 - name.length()));
        if (stage.isDone()) {
            bytesPerSecond = FormatUtils.formatDataRate(new DataSize(0.0, DataSize.Unit.BYTE), new Duration(0.0, TimeUnit.SECONDS), false);
            rowsPerSecond = FormatUtils.formatCountRate(0.0, new Duration(0.0, TimeUnit.SECONDS), false);
        } else {
            bytesPerSecond = FormatUtils.formatDataRate(StatusPrinter.bytes(stage.getProcessedBytes()), elapsedTime, false);
            rowsPerSecond = FormatUtils.formatCountRate(stage.getProcessedRows(), elapsedTime, false);
        }
        String stageSummary = String.format("%10s%1s  %5s  %6s  %5s  %7s  %6s  %5s  %5s", name, Character.valueOf(StatusPrinter.stageStateCharacter(stage.getState())), FormatUtils.formatCount(stage.getProcessedRows()), rowsPerSecond, FormatUtils.formatDataSize(StatusPrinter.bytes(stage.getProcessedBytes()), false), bytesPerSecond, stage.getQueuedSplits(), stage.getRunningSplits(), stage.getCompletedSplits());
        this.reprintLine(stageSummary);
        for (StageStats subStage : stage.getSubStages()) {
            this.printStageTree(subStage, indent + "  ", stageNumberCounter);
        }
    }

    private void reprintLine(String line) {
        this.console.reprintLine(line);
    }

    private static char stageStateCharacter(String state) {
        return "FAILED".equals(state) ? (char)'X' : state.charAt(0);
    }

    private static Duration millis(long millis) {
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    private static DataSize bytes(long bytes) {
        return new DataSize((double)bytes, DataSize.Unit.BYTE);
    }

    private static double percentage(double count, double total) {
        if (total == 0.0) {
            return 0.0;
        }
        return Math.min(100.0, count * 100.0 / total);
    }
}

