/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.Query;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.client.spnego.KerberosConfig;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class QueryRunner
implements Closeable {
    private final JsonCodec<QueryResults> queryResultsCodec;
    private final AtomicReference<ClientSession> session;
    private final HttpClient httpClient;

    public QueryRunner(ClientSession session, JsonCodec<QueryResults> queryResultsCodec, Optional<HostAndPort> socksProxy, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> kerberosPrincipal, Optional<String> kerberosRemoteServiceName, boolean authenticationEnabled, KerberosConfig kerberosConfig) {
        this.session = new AtomicReference<Object>(Preconditions.checkNotNull((Object)session, (Object)"session is null"));
        this.queryResultsCodec = (JsonCodec)Preconditions.checkNotNull(queryResultsCodec, (Object)"queryResultsCodec is null");
        this.httpClient = new JettyHttpClient(QueryRunner.getHttpClientConfig(socksProxy, keystorePath, keystorePassword, kerberosPrincipal, kerberosRemoteServiceName, authenticationEnabled), kerberosConfig, Optional.empty(), (Iterable)ImmutableList.of());
    }

    public ClientSession getSession() {
        return this.session.get();
    }

    public void setSession(ClientSession session) {
        this.session.set((ClientSession)Preconditions.checkNotNull((Object)session, (Object)"session is null"));
    }

    public Query startQuery(String query) {
        return new Query(this.startInternalQuery(query));
    }

    public StatementClient startInternalQuery(String query) {
        return new StatementClient(this.httpClient, this.queryResultsCodec, this.session.get(), query);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public static QueryRunner create(ClientSession session, Optional<HostAndPort> socksProxy, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> kerberosPrincipal, Optional<String> kerberosRemoteServiceName, boolean authenticationEnabled, KerberosConfig kerberosConfig) {
        return new QueryRunner(session, (JsonCodec<QueryResults>)JsonCodec.jsonCodec(QueryResults.class), socksProxy, keystorePath, keystorePassword, kerberosPrincipal, kerberosRemoteServiceName, authenticationEnabled, kerberosConfig);
    }

    private static HttpClientConfig getHttpClientConfig(Optional<HostAndPort> socksProxy, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> kerberosPrincipal, Optional<String> kerberosRemoteServiceName, boolean authenticationEnabled) {
        HttpClientConfig httpClientConfig = new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS));
        socksProxy.ifPresent(arg_0 -> ((HttpClientConfig)httpClientConfig).setSocksProxy(arg_0));
        httpClientConfig.setAuthenticationEnabled(authenticationEnabled);
        keystorePath.ifPresent(arg_0 -> ((HttpClientConfig)httpClientConfig).setKeyStorePath(arg_0));
        keystorePassword.ifPresent(arg_0 -> ((HttpClientConfig)httpClientConfig).setKeyStorePassword(arg_0));
        kerberosPrincipal.ifPresent(arg_0 -> ((HttpClientConfig)httpClientConfig).setKerberosPrincipal(arg_0));
        kerberosRemoteServiceName.ifPresent(arg_0 -> ((HttpClientConfig)httpClientConfig).setKerberosRemoteServiceName(arg_0));
        return httpClientConfig;
    }
}

