/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import com.facebook.presto.cli.ClientOptions;
import com.facebook.presto.cli.Query;
import com.facebook.presto.cli.QueryRunner;
import com.facebook.presto.cli.VersionOption;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.parser.StatementSplitter;
import com.facebook.presto.sql.tree.Use;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.airlift.command.Command;
import io.airlift.command.HelpOption;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import jline.console.history.FileHistory;
import jline.console.history.MemoryHistory;
import jline.internal.Configuration;
import org.fusesource.jansi.AnsiConsole;

@Command(name="presto", description="Presto interactive console")
public class Console
implements Runnable {
    private static final String PROMPT_NAME = "presto";
    private static final SqlParser SQL_PARSER = new SqlParser(new SqlParserOptions().allowIdentifierSymbol(EnumSet.allOf(IdentifierSymbol.class)));
    @Inject
    public HelpOption helpOption;
    @Inject
    public VersionOption versionOption = new VersionOption();
    @Inject
    public ClientOptions clientOptions = new ClientOptions();

    @Override
    public void run() {
        boolean isFromFile;
        ClientSession session = this.clientOptions.toClientSession();
        boolean hasQuery = !Strings.isNullOrEmpty((String)this.clientOptions.execute);
        boolean bl = isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        if (!hasQuery || !isFromFile) {
            AnsiConsole.systemInstall();
        }
        Console.initializeLogging(session.isDebug());
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.toString((File)new File(this.clientOptions.file), (Charset)StandardCharsets.UTF_8);
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        try (QueryRunner queryRunner = QueryRunner.create(session, Optional.ofNullable(this.clientOptions.socksProxy));){
            if (hasQuery) {
                Console.executeCommand(queryRunner, query, this.clientOptions.outputFormat);
            } else {
                Console.runConsole(queryRunner, session);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void runConsole(QueryRunner queryRunner, ClientSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 36[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<Object> getParsedStatement(String statement) {
        try {
            return Optional.of(SQL_PARSER.createStatement(statement));
        }
        catch (ParsingException e) {
            return Optional.empty();
        }
    }

    static ClientSession processSessionParameterChange(Object parsedStatement, ClientSession session) {
        if (parsedStatement instanceof Use) {
            Use use = (Use)parsedStatement;
            return ClientSession.withCatalogAndSchema((ClientSession)session, (String)use.getCatalog().orElse(session.getCatalog()), (String)use.getSchema());
        }
        return session;
    }

    private static boolean isSessionParameterChange(Object statement) {
        return statement instanceof Use;
    }

    private static void executeCommand(QueryRunner queryRunner, String query, ClientOptions.OutputFormat outputFormat) {
        StatementSplitter splitter = new StatementSplitter(query);
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            if (StatementSplitter.isEmptyStatement((String)split.statement())) continue;
            Console.process(queryRunner, split.statement(), outputFormat, false);
        }
        if (!StatementSplitter.isEmptyStatement((String)splitter.getPartialStatement())) {
            System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
        }
    }

    private static void process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, boolean interactive) {
        block15: {
            try (Query query = queryRunner.startQuery(sql);){
                query.renderOutput(System.out, outputFormat, interactive);
                if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                    HashMap<String, String> sessionProperties = new HashMap<String, String>(queryRunner.getSession().getProperties());
                    sessionProperties.putAll(query.getSetSessionProperties());
                    sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                    queryRunner.setSession(ClientSession.withProperties((ClientSession)queryRunner.getSession(), sessionProperties));
                }
            }
            catch (RuntimeException e) {
                System.out.println("Error running command: " + e.getMessage());
                if (!queryRunner.getSession().isDebug()) break block15;
                e.printStackTrace();
            }
        }
    }

    private static MemoryHistory getHistory() {
        FileHistory history;
        File historyFile = new File(Configuration.getUserHome(), ".presto_history");
        try {
            history = new FileHistory(historyFile);
        }
        catch (IOException e) {
            System.err.printf("WARNING: Failed to load history file (%s): %s. History will not be available during this session.%n", historyFile, e.getMessage());
            history = new MemoryHistory();
        }
        history.setAutoTrim(true);
        return history;
    }

    public static void initializeLogging(boolean debug) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            if (debug) {
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.setLevel("com.facebook.presto", Logging.Level.DEBUG);
            } else {
                System.setOut(Console.nullPrintStream());
                System.setErr(Console.nullPrintStream());
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.disableConsole();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static PrintStream nullPrintStream() {
        return new PrintStream(ByteStreams.nullOutputStream());
    }
}

