/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.alluxio.AlluxioCachingFileSystem;
import com.facebook.presto.cache.filemerge.FileMergeCachingFileSystem;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public class CacheFactory {
    public ExtendedFileSystem createCachingFileSystem(Configuration factoryConfig, URI factoryUri, ExtendedFileSystem fileSystem, CacheManager cacheManager, boolean cachingEnabled, CacheConfig cacheConfig) throws IOException {
        if (!cachingEnabled) {
            return fileSystem;
        }
        Preconditions.checkState((cacheConfig != null && cacheConfig.getCacheType() != null ? 1 : 0) != 0);
        switch (cacheConfig.getCacheType()) {
            case FILE_MERGE: {
                return new FileMergeCachingFileSystem(factoryUri, factoryConfig, cacheManager, fileSystem, cacheConfig.isValidationEnabled());
            }
            case ALLUXIO: {
                AlluxioCachingFileSystem cachingFileSystem = new AlluxioCachingFileSystem(fileSystem, factoryUri, cacheConfig.isValidationEnabled(), cacheConfig.isLastModifiedTimeCheckEnabled());
                cachingFileSystem.initialize(factoryUri, factoryConfig);
                return cachingFileSystem;
            }
        }
        throw new IllegalArgumentException("Invalid CacheType: " + (Object)((Object)cacheConfig.getCacheType()));
    }
}

