/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public abstract class CachingFileSystem
extends ExtendedFileSystem {
    protected final ExtendedFileSystem dataTier;
    protected final URI uri;

    public CachingFileSystem(ExtendedFileSystem dataTier, URI uri) {
        this.dataTier = Objects.requireNonNull(dataTier, "dataTier is null");
        this.uri = Objects.requireNonNull(uri, "uri is null");
    }

    public ExtendedFileSystem getDataTier() {
        return this.dataTier;
    }

    public String getScheme() {
        return this.dataTier.getScheme();
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration configuration) throws IOException {
        this.dataTier.initialize(uri, configuration);
    }

    public Configuration getConf() {
        return this.dataTier.getConf();
    }

    public Path getWorkingDirectory() {
        return this.dataTier.getWorkingDirectory();
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.dataTier.setWorkingDirectory(workingDirectory);
    }

    public long getDefaultBlockSize() {
        return this.dataTier.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.dataTier.getDefaultReplication();
    }

    public Path getHomeDirectory() {
        return this.dataTier.getHomeDirectory();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus fileStatus, long offset, long length) throws IOException {
        return this.dataTier.getFileBlockLocations(fileStatus, offset, length);
    }

    public BlockLocation[] getFileBlockLocations(Path path, long offset, long length) throws IOException {
        return this.dataTier.getFileBlockLocations(path, offset, length);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.dataTier.setVerifyChecksum(verifyChecksum);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return this.dataTier.open(path, bufferSize);
    }

    public abstract FSDataInputStream openFile(Path var1, HiveFileContext var2) throws Exception;

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
        return this.dataTier.append(path, bufferSize, progressable);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
        return this.dataTier.create(path, permission, overwrite, bufferSize, replication, blockSize, progressable);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, EnumSet<CreateFlag> createFlags, int bufferSize, short replication, long blockSize, Progressable progressable, Options.ChecksumOpt checksumOption) throws IOException {
        return this.dataTier.create(path, permission, createFlags, bufferSize, replication, blockSize, progressable, checksumOption);
    }

    public boolean setReplication(Path path, short replication) throws IOException {
        return this.dataTier.setReplication(path, replication);
    }

    public void concat(Path targetPath, Path[] sourcePaths) throws IOException {
        this.dataTier.concat(targetPath, sourcePaths);
    }

    public boolean rename(Path source, Path destination) throws IOException {
        return this.dataTier.rename(source, destination);
    }

    public boolean truncate(Path path, long length) throws IOException {
        return this.dataTier.truncate(path, length);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.dataTier.delete(path, recursive);
    }

    public ContentSummary getContentSummary(Path path) throws IOException {
        return this.dataTier.getContentSummary(path);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.dataTier.listStatus(path);
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path path) throws IOException {
        return this.dataTier.listStatusIterator(path);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        return this.dataTier.mkdirs(path, permission);
    }

    public void close() throws IOException {
        this.dataTier.close();
    }

    public FsStatus getStatus(Path path) throws IOException {
        return this.dataTier.getStatus(path);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.dataTier.listCorruptFileBlocks(path);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dataTier.getServerDefaults();
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.dataTier.getFileStatus(path);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.dataTier.createSymlink(target, link, createParent);
    }

    public boolean supportsSymlinks() {
        return this.dataTier.supportsSymlinks();
    }

    public FileStatus getFileLinkStatus(Path path) throws IOException {
        return this.dataTier.getFileLinkStatus(path);
    }

    public Path getLinkTarget(Path path) throws IOException {
        return this.dataTier.getLinkTarget(path);
    }

    public FileChecksum getFileChecksum(Path path) throws IOException {
        return this.dataTier.getFileChecksum(path);
    }

    public FileChecksum getFileChecksum(Path path, long length) throws IOException {
        return this.dataTier.getFileChecksum(path, length);
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        this.dataTier.setPermission(path, permission);
    }

    public void setOwner(Path path, String user, String group) throws IOException {
        this.dataTier.setOwner(path, user, group);
    }

    public void setTimes(Path path, long modificationTime, long accessTime) throws IOException {
        this.dataTier.setTimes(path, modificationTime, accessTime);
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.dataTier.getDelegationToken(renewer);
    }

    public String getCanonicalServiceName() {
        return this.dataTier.getCanonicalServiceName();
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.dataTier.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.dataTier.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path snapshotDirectory, String snapshotName) throws IOException {
        this.dataTier.deleteSnapshot(snapshotDirectory, snapshotName);
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclEntries) throws IOException {
        this.dataTier.modifyAclEntries(path, aclEntries);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclEntries) throws IOException {
        this.dataTier.removeAclEntries(path, aclEntries);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.dataTier.removeDefaultAcl(path);
    }

    public void removeAcl(Path path) throws IOException {
        this.dataTier.removeAcl(path);
    }

    public void setAcl(Path path, List<AclEntry> aclEntries) throws IOException {
        this.dataTier.setAcl(path, aclEntries);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        return this.dataTier.getAclStatus(path);
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> xAttrSetFlags) throws IOException {
        this.dataTier.setXAttr(path, name, value, xAttrSetFlags);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.dataTier.getXAttr(path, name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.dataTier.getXAttrs(path);
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.dataTier.getXAttrs(path, names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return this.dataTier.listXAttrs(path);
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.dataTier.removeXAttr(path, name);
    }

    public void access(Path path, FsAction mode) throws IOException {
        this.dataTier.access(path, mode);
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        return this.dataTier.addDelegationTokens(renewer, credentials);
    }

    public Path makeQualified(Path path) {
        return this.dataTier.makeQualified(path);
    }

    public RemoteIterator<LocatedFileStatus> listDirectory(Path path) throws IOException {
        return this.dataTier.listDirectory(path);
    }

    public RemoteIterator<HiveFileInfo> listFiles(Path path) throws IOException {
        return this.dataTier.listFiles(path);
    }

    public ListenableFuture<Void> renameFileAsync(Path source, Path destination) throws IOException {
        return this.dataTier.renameFileAsync(source, destination);
    }
}

