/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cache;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.cache.CacheType;
import java.net.URI;

public class CacheConfig {
    private boolean cachingEnabled;
    private CacheType cacheType;
    private URI baseDirectory;
    private boolean validationEnabled;

    public URI getBaseDirectory() {
        return this.baseDirectory;
    }

    @Config(value="cache.base-directory")
    @ConfigDescription(value="Base URI to cache data")
    public CacheConfig setBaseDirectory(URI dataURI) {
        this.baseDirectory = dataURI;
        return this;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Config(value="cache.validation-enabled")
    @ConfigDescription(value="Enable cache validation by comparing with actual data with cached data")
    public CacheConfig setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    @Config(value="cache.enabled")
    @ConfigDescription(value="Is cache enabled")
    public CacheConfig setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
        return this;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    @Config(value="cache.type")
    @ConfigDescription(value="Caching type")
    public CacheConfig setCacheType(CacheType cacheType) {
        this.cacheType = cacheType;
        return this;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }
}

