/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.instruction;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class LabelNode
implements InstructionNode {
    private final String name;
    private final Label label;

    public LabelNode() {
        this.label = new Label();
        this.name = "label@" + this.label.hashCode();
    }

    public LabelNode(LabelNode labelNode) {
        this.label = labelNode.getLabel();
        this.name = "label@" + this.label.hashCode();
    }

    public LabelNode(String name) {
        this.label = new Label();
        this.name = name + "@" + this.label.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        visitor.visitLabel(this.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitLabel(parent, this);
    }
}

