/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DynamicClassLoader
extends ClassLoader {
    private final ConcurrentMap<String, byte[]> pendingClasses = new ConcurrentHashMap<String, byte[]>();
    private final Map<Long, MethodHandle> callSiteBindings;
    private final Optional<ClassLoader> overrideClassLoader;

    public DynamicClassLoader(ClassLoader parentClassLoader) {
        this(parentClassLoader, (Map<Long, MethodHandle>)ImmutableMap.of());
    }

    @Deprecated
    public DynamicClassLoader(ClassLoader overrideClassLoader, ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.callSiteBindings = ImmutableMap.of();
        this.overrideClassLoader = Optional.of(overrideClassLoader);
    }

    public DynamicClassLoader(ClassLoader parentClassLoader, Map<Long, MethodHandle> callSiteBindings) {
        super(parentClassLoader);
        this.callSiteBindings = ImmutableMap.copyOf(callSiteBindings);
        this.overrideClassLoader = Optional.empty();
    }

    public Class<?> defineClass(String className, byte[] bytecode) {
        return this.defineClass(className, bytecode, 0, bytecode.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> defineClasses(Map<String, byte[]> newClasses) {
        Sets.SetView conflicts = Sets.intersection(this.pendingClasses.keySet(), newClasses.keySet());
        Preconditions.checkArgument((boolean)conflicts.isEmpty(), (String)"The classes %s have already been defined", (Object)conflicts);
        this.pendingClasses.putAll(newClasses);
        try {
            HashMap classes = new HashMap();
            for (String className : newClasses.keySet()) {
                try {
                    Class<?> clazz = this.loadClass(className);
                    classes.put(className, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            HashMap<String, Class<?>> hashMap = classes;
            return hashMap;
        }
        finally {
            this.pendingClasses.keySet().removeAll(newClasses.keySet());
        }
    }

    public Map<Long, MethodHandle> getCallSiteBindings() {
        return this.callSiteBindings;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytecode = (byte[])this.pendingClasses.get(name);
        if (bytecode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytecode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cachedClass = this.findLoadedClass(name);
            if (cachedClass != null) {
                return this.resolveClass(cachedClass, resolve);
            }
            try {
                Class<?> clazz2 = this.findClass(name);
                return this.resolveClass(clazz2, resolve);
            }
            catch (ClassNotFoundException clazz2) {
                if (this.overrideClassLoader.isPresent()) {
                    try {
                        return this.resolveClass(this.overrideClassLoader.get().loadClass(name), resolve);
                    }
                    catch (ClassNotFoundException clazz2) {
                        // empty catch block
                    }
                }
                Class<?> clazz3 = this.getParent().loadClass(name);
                return this.resolveClass(clazz3, resolve);
            }
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

