/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.util.List;
import java.util.Objects;

class CastBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;

    public CastBytecodeExpression(BytecodeExpression instance, ParameterizedType type) {
        super(type);
        this.instance = Objects.requireNonNull(instance, "instance is null");
        Preconditions.checkArgument((type.getPrimitiveType() != Void.TYPE ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object[])new Object[]{instance.getType(), type});
        if (instance.getType().isPrimitive() != type.isPrimitive()) {
            Preconditions.checkArgument((CastBytecodeExpression.unwrapPrimitiveType(instance.getType()) == CastBytecodeExpression.unwrapPrimitiveType(type) ? 1 : 0) != 0, (String)"Type %s can not be cast to %s", (Object[])new Object[]{instance.getType(), type});
        }
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock().append(this.instance.getBytecode(generationContext));
        if (this.instance.getType().isPrimitive()) {
            Class<?> sourceType = this.instance.getType().getPrimitiveType();
            CastBytecodeExpression.castPrimitiveToPrimitive(block, sourceType, CastBytecodeExpression.unwrapPrimitiveType(this.getType()));
            if (!this.getType().isPrimitive()) {
                Class<?> primitiveTargetType = CastBytecodeExpression.unwrapPrimitiveType(this.getType());
                return block.invokeStatic(this.getType(), "valueOf", this.getType(), ParameterizedType.type(primitiveTargetType));
            }
            return block;
        }
        if (this.getType().isPrimitive()) {
            Class<?> targetType = this.getType().getPrimitiveType();
            return block.invokeVirtual(Primitives.wrap(targetType), targetType.getSimpleName() + "Value", targetType, new Class[0]);
        }
        block.checkCast(this.getType());
        return block;
    }

    private static BytecodeBlock castPrimitiveToPrimitive(BytecodeBlock block, Class<?> sourceType, Class<?> targetType) {
        if (sourceType == Boolean.TYPE && targetType == Boolean.TYPE) {
            return block;
        }
        if (sourceType == Byte.TYPE) {
            if (targetType == Byte.TYPE) {
                return block;
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Character.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block;
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Short.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block;
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Integer.TYPE) {
            if (targetType == Boolean.TYPE) {
                return block;
            }
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block;
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.I2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.I2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.I2D);
            }
        }
        if (sourceType == Long.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.L2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.L2I);
            }
            if (targetType == Long.TYPE) {
                return block;
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.L2F);
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.L2D);
            }
        }
        if (sourceType == Float.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.F2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.F2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.F2L);
            }
            if (targetType == Float.TYPE) {
                return block;
            }
            if (targetType == Double.TYPE) {
                return block.append(OpCode.F2D);
            }
        }
        if (sourceType == Double.TYPE) {
            if (targetType == Byte.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2B);
            }
            if (targetType == Character.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2C);
            }
            if (targetType == Short.TYPE) {
                return block.append(OpCode.D2I).append(OpCode.I2S);
            }
            if (targetType == Integer.TYPE) {
                return block.append(OpCode.D2I);
            }
            if (targetType == Long.TYPE) {
                return block.append(OpCode.D2L);
            }
            if (targetType == Float.TYPE) {
                return block.append(OpCode.D2F);
            }
            if (targetType == Double.TYPE) {
                return block;
            }
        }
        throw new IllegalArgumentException(String.format("Type %s can not be cast to %s", sourceType, targetType));
    }

    private static Class<?> unwrapPrimitiveType(ParameterizedType type) {
        if (type.isPrimitive()) {
            return type.getPrimitiveType();
        }
        switch (type.getJavaClassName()) {
            case "java.lang.Boolean": {
                return Boolean.TYPE;
            }
            case "java.lang.Byte": {
                return Byte.TYPE;
            }
            case "java.lang.Character": {
                return Character.TYPE;
            }
            case "java.lang.Short": {
                return Short.TYPE;
            }
            case "java.lang.Integer": {
                return Integer.TYPE;
            }
            case "java.lang.Long": {
                return Long.TYPE;
            }
            case "java.lang.Float": {
                return Float.TYPE;
            }
            case "java.lang.Double": {
                return Double.TYPE;
            }
        }
        return null;
    }

    @Override
    protected String formatOneLine() {
        return "((" + this.getType().getSimpleName() + ") " + this.instance + ")";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance);
    }
}

