/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.builtin.tools;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.spi.function.AggregationFunctionMetadata;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class WorkerFunctionUtil {
    private WorkerFunctionUtil() {
    }

    public static synchronized SqlInvokedFunction createSqlInvokedFunction(String functionName, JsonBasedUdfFunctionMetadata jsonBasedUdfFunctionMetaData, String catalogName) {
        Preconditions.checkState((boolean)jsonBasedUdfFunctionMetaData.getRoutineCharacteristics().getLanguage().equals((Object)RoutineCharacteristics.Language.CPP), (Object)"WorkerFunctionUtil only supports CPP UDF");
        QualifiedObjectName qualifiedFunctionName = QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName(catalogName, jsonBasedUdfFunctionMetaData.getSchema()), (String)functionName);
        List parameterNameList = jsonBasedUdfFunctionMetaData.getParamNames();
        List<TypeSignature> parameterTypeList = WorkerFunctionUtil.convertApplicableTypeToVariable(jsonBasedUdfFunctionMetaData.getParamTypes());
        ImmutableList typeVariableConstraintsList = jsonBasedUdfFunctionMetaData.getTypeVariableConstraints().isPresent() ? (List)jsonBasedUdfFunctionMetaData.getTypeVariableConstraints().get() : ImmutableList.of();
        ImmutableList longVariableConstraintList = jsonBasedUdfFunctionMetaData.getLongVariableConstraints().isPresent() ? (List)jsonBasedUdfFunctionMetaData.getLongVariableConstraints().get() : ImmutableList.of();
        TypeSignature outputType = WorkerFunctionUtil.convertApplicableTypeToVariable(jsonBasedUdfFunctionMetaData.getOutputType());
        ImmutableList.Builder parameterBuilder = ImmutableList.builder();
        for (int i = 0; i < parameterNameList.size(); ++i) {
            parameterBuilder.add((Object)new Parameter((String)parameterNameList.get(i), parameterTypeList.get(i)));
        }
        Optional<AggregationFunctionMetadata> aggregationFunctionMetadata = jsonBasedUdfFunctionMetaData.getAggregateMetadata().map(metadata -> new AggregationFunctionMetadata(WorkerFunctionUtil.convertApplicableTypeToVariable(metadata.getIntermediateType()), metadata.isOrderSensitive()));
        return new SqlInvokedFunction(qualifiedFunctionName, (List)parameterBuilder.build(), (List)typeVariableConstraintsList, (List)longVariableConstraintList, outputType, jsonBasedUdfFunctionMetaData.getDocString(), jsonBasedUdfFunctionMetaData.getRoutineCharacteristics(), "", jsonBasedUdfFunctionMetaData.getVariableArity(), FunctionVersion.notVersioned(), jsonBasedUdfFunctionMetaData.getFunctionKind(), aggregationFunctionMetadata);
    }

    public static List<TypeSignature> convertApplicableTypeToVariable(List<TypeSignature> typeSignatures) {
        ArrayList<TypeSignature> newTypeSignaturesList = new ArrayList<TypeSignature>();
        for (TypeSignature typeSignature : typeSignatures) {
            if (!typeSignature.getParameters().isEmpty()) {
                TypeSignature newTypeSignature = new TypeSignature(typeSignature.getBase(), WorkerFunctionUtil.getTypeSignatureParameters(typeSignature, typeSignature.getParameters()));
                newTypeSignaturesList.add(newTypeSignature);
                continue;
            }
            newTypeSignaturesList.add(typeSignature);
        }
        return newTypeSignaturesList;
    }

    public static TypeSignature convertApplicableTypeToVariable(TypeSignature typeSignature) {
        List<TypeSignature> typeSignaturesList = WorkerFunctionUtil.convertApplicableTypeToVariable((List<TypeSignature>)ImmutableList.of((Object)typeSignature));
        Preconditions.checkArgument((!typeSignaturesList.isEmpty() ? 1 : 0) != 0, (Object)("Type signature list is empty for : " + String.valueOf(typeSignature)));
        return typeSignaturesList.get(0);
    }

    private static List<TypeSignatureParameter> getTypeSignatureParameters(TypeSignature typeSignature, List<TypeSignatureParameter> typeSignatureParameterList) {
        ArrayList<TypeSignatureParameter> newParameterTypeList = new ArrayList<TypeSignatureParameter>();
        for (TypeSignatureParameter parameter : typeSignatureParameterList) {
            if (parameter.isLongLiteral()) {
                newParameterTypeList.add(parameter);
                continue;
            }
            boolean isNamedTypeSignature = parameter.isNamedTypeSignature();
            TypeSignature parameterTypeSignature = isNamedTypeSignature ? parameter.getNamedTypeSignature().getTypeSignature() : parameter.getTypeSignature();
            if (parameterTypeSignature.getParameters().isEmpty()) {
                boolean changeTypeToVariable = WorkerFunctionUtil.isDecimalTypeBase(typeSignature.getBase());
                if (changeTypeToVariable) {
                    newParameterTypeList.add(TypeSignatureParameter.of((String)parameterTypeSignature.getBase()));
                    continue;
                }
                if (isNamedTypeSignature) {
                    newParameterTypeList.add(TypeSignatureParameter.of((NamedTypeSignature)parameter.getNamedTypeSignature()));
                    continue;
                }
                newParameterTypeList.add(TypeSignatureParameter.of((TypeSignature)parameterTypeSignature));
                continue;
            }
            TypeSignature newTypeSignature = new TypeSignature(parameterTypeSignature.getBase(), WorkerFunctionUtil.getTypeSignatureParameters(parameterTypeSignature.getStandardTypeSignature(), parameterTypeSignature.getParameters()));
            if (isNamedTypeSignature) {
                newParameterTypeList.add(TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), newTypeSignature)));
                continue;
            }
            newParameterTypeList.add(TypeSignatureParameter.of((TypeSignature)newTypeSignature));
        }
        return newParameterTypeList;
    }

    private static boolean isDecimalTypeBase(String typeBase) {
        return typeBase.equals("decimal");
    }
}

