/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.plugin.bigquery.ReadSessionCreatorConfig;
import com.google.auth.oauth2.GoogleCredentials;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalInt;

public class BigQueryConfig {
    public static final int DEFAULT_MAX_READ_ROWS_RETRIES = 3;
    private static final int VIEW_EXPIRATION_TIMEIN_HOURS = 24;
    private Optional<String> credentialsKey = Optional.empty();
    private Optional<String> credentialsFile = Optional.empty();
    private Optional<String> projectId = Optional.empty();
    private Optional<String> parentProjectId = Optional.empty();
    private OptionalInt parallelism = OptionalInt.empty();
    private boolean viewsEnabled;
    private boolean caseSensitiveNameMatching;
    private Optional<String> viewMaterializationProject = Optional.empty();
    private Optional<String> viewMaterializationDataset = Optional.empty();
    private int maxReadRowsRetries = 3;

    @AssertTrue(message="Either one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified, or the default GoogleCredentials could be created")
    public @AssertTrue(message="Either one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified, or the default GoogleCredentials could be created") boolean isCredentialsConfigurationValid() {
        if (this.credentialsKey.isPresent() && this.credentialsFile.isPresent()) {
            return false;
        }
        if (!this.credentialsKey.isPresent() && !this.credentialsFile.isPresent()) {
            try {
                GoogleCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public Optional<String> getCredentialsKey() {
        return this.credentialsKey;
    }

    @Config(value="bigquery.credentials-key")
    @ConfigDescription(value="credentials key (base64 encoded)")
    public BigQueryConfig setCredentialsKey(String credentialsKey) {
        this.credentialsKey = Optional.of(credentialsKey);
        return this;
    }

    public Optional<String> getCredentialsFile() {
        return this.credentialsFile;
    }

    @Config(value="bigquery.credentials-file")
    @ConfigDescription(value="JSON credentials file path")
    public BigQueryConfig setCredentialsFile(String credentialsFile) {
        this.credentialsFile = Optional.of(credentialsFile);
        return this;
    }

    public Optional<String> getProjectId() {
        return this.projectId;
    }

    @Config(value="bigquery.project-id")
    @ConfigDescription(value="Google Cloud project ID")
    public BigQueryConfig setProjectId(String projectId) {
        this.projectId = Optional.of(projectId);
        return this;
    }

    public Optional<String> getParentProjectId() {
        return this.parentProjectId;
    }

    @Config(value="bigquery.parent-project-id")
    @ConfigDescription(value="Google Cloud parent project ID")
    public BigQueryConfig setParentProjectId(String parentProjectId) {
        this.parentProjectId = Optional.of(parentProjectId);
        return this;
    }

    public OptionalInt getParallelism() {
        return this.parallelism;
    }

    @Config(value="bigquery.parallelism")
    @ConfigDescription(value="The number of partitions to split the data")
    public BigQueryConfig setParallelism(int parallelism) {
        this.parallelism = OptionalInt.of(parallelism);
        return this;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Config(value="bigquery.views-enabled")
    @ConfigDescription(value="Enable BigQuery connector to read views")
    public BigQueryConfig setViewsEnabled(boolean viewsEnabled) {
        this.viewsEnabled = viewsEnabled;
        return this;
    }

    public int getViewExpirationTimeInHours() {
        return 24;
    }

    public Optional<String> getViewMaterializationProject() {
        return this.viewMaterializationProject;
    }

    @Config(value="bigquery.view-materialization-project")
    @ConfigDescription(value="The project where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationProject(String viewMaterializationProject) {
        this.viewMaterializationProject = Optional.of(viewMaterializationProject);
        return this;
    }

    public Optional<String> getViewMaterializationDataset() {
        return this.viewMaterializationDataset;
    }

    @Config(value="bigquery.view-materialization-dataset")
    @ConfigDescription(value="The dataset where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationDataset(String viewMaterializationDataset) {
        this.viewMaterializationDataset = Optional.of(viewMaterializationDataset);
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    @Config(value="bigquery.max-read-rows-retries")
    @ConfigDescription(value="The number of retries in case of server issues")
    public BigQueryConfig setMaxReadRowsRetries(int maxReadRowsRetries) {
        this.maxReadRowsRetries = maxReadRowsRetries;
        return this;
    }

    public boolean isCaseSensitiveNameMatching() {
        return this.caseSensitiveNameMatching;
    }

    @Config(value="case-sensitive-name-matching")
    @ConfigDescription(value="Case sensitivity for schema and table name matching. true = preserve case and require exact matches; false (default) = normalize to lower case and match case-insensitively.")
    public BigQueryConfig setCaseSensitiveNameMatching(boolean caseSensitiveNameMatching) {
        this.caseSensitiveNameMatching = caseSensitiveNameMatching;
        return this;
    }

    ReadSessionCreatorConfig createReadSessionCreatorConfig() {
        return new ReadSessionCreatorConfig(this.getParentProjectId(), this.isViewsEnabled(), this.getViewMaterializationProject(), this.getViewMaterializationProject(), this.getViewExpirationTimeInHours(), this.getMaxReadRowsRetries());
    }
}

