/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.bigquery.BigQueryMetadata;
import com.facebook.presto.plugin.bigquery.BigQueryPageSourceProvider;
import com.facebook.presto.plugin.bigquery.BigQuerySplitManager;
import com.facebook.presto.plugin.bigquery.BigQueryTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import jakarta.inject.Inject;
import java.util.Objects;

public class BigQueryConnector
implements Connector {
    private static final Logger log = Logger.get(BigQueryConnector.class);
    private final BigQueryMetadata metadata;
    private final BigQuerySplitManager splitManager;
    private final BigQueryPageSourceProvider pageSourceProvider;

    @Inject
    public BigQueryConnector(BigQueryMetadata metadata, BigQuerySplitManager splitManager, BigQueryPageSourceProvider pageSourceProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        log.debug("beginTransaction(isolationLevel=%s, readOnly=%s)", new Object[]{isolationLevel, readOnly});
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return BigQueryTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }
}

