/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.presto.plugin.bigquery.BigQueryConfig;
import com.facebook.presto.plugin.bigquery.BigQueryErrorCode;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class BigQueryClient {
    private final BigQuery bigQuery;
    private final Optional<String> viewMaterializationProject;
    private final Optional<String> viewMaterializationDataset;
    private final String tablePrefix = "_pbc_";
    private final boolean caseSensitiveNameMatching;
    private final ConcurrentMap<TableId, TableId> tableIds = new ConcurrentHashMap<TableId, TableId>();
    private final ConcurrentMap<DatasetId, DatasetId> datasetIds = new ConcurrentHashMap<DatasetId, DatasetId>();

    BigQueryClient(BigQuery bigQuery, BigQueryConfig config) {
        this.bigQuery = Objects.requireNonNull(bigQuery, "bigQuery is null");
        this.viewMaterializationProject = Objects.requireNonNull(config.getViewMaterializationProject(), "viewMaterializationProject is null");
        this.viewMaterializationDataset = Objects.requireNonNull(config.getViewMaterializationDataset(), "viewMaterializationDataset is null");
        this.caseSensitiveNameMatching = config.isCaseSensitiveNameMatching();
    }

    public TableInfo getTable(TableId tableId) {
        Table table = this.bigQuery.getTable(tableId, new BigQuery.TableOption[0]);
        if (table != null) {
            this.tableIds.putIfAbsent(tableId, table.getTableId());
            this.datasetIds.putIfAbsent(this.toDatasetId(tableId), this.toDatasetId(table.getTableId()));
        }
        return table;
    }

    private DatasetId toDatasetId(TableId tableId) {
        return DatasetId.of((String)tableId.getProject(), (String)tableId.getDataset());
    }

    protected String getProjectId() {
        return ((BigQueryOptions)this.bigQuery.getOptions()).getProjectId();
    }

    protected Iterable<Dataset> listDatasets(String projectId) {
        Iterator datasets = this.bigQuery.listDatasets(projectId, new BigQuery.DatasetListOption[0]).iterateAll().iterator();
        return () -> Iterators.transform((Iterator)datasets, this::addDataSetMappingIfNeeded);
    }

    protected Iterable<Table> listTables(DatasetId datasetId, TableDefinition.Type ... types) {
        ImmutableSet allowedTypes = ImmutableSet.copyOf((Object[])types);
        DatasetId bigQueryDatasetId = this.datasetIds.getOrDefault(datasetId, datasetId);
        Iterable allTables = this.bigQuery.listTables(bigQueryDatasetId, new BigQuery.TableListOption[0]).iterateAll();
        allTables.forEach(table -> this.addTableMappingIfNeeded(bigQueryDatasetId, (Table)table));
        return (Iterable)StreamSupport.stream(allTables.spliterator(), false).filter(arg_0 -> BigQueryClient.lambda$listTables$2((Set)allowedTypes, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private void addTableMappingIfNeeded(DatasetId datasetID, Table table) {
        TableId bigQueryTableId = table.getTableId();
        TableId prestoTableId = TableId.of((String)datasetID.getProject(), (String)datasetID.getDataset(), (String)this.createTableName());
        this.tableIds.putIfAbsent(bigQueryTableId, prestoTableId);
    }

    private Dataset addDataSetMappingIfNeeded(Dataset dataset) {
        DatasetId bigQueryDatasetId = dataset.getDatasetId();
        DatasetId prestoDatasetId = DatasetId.of((String)bigQueryDatasetId.getProject(), (String)bigQueryDatasetId.getDataset());
        this.datasetIds.putIfAbsent(prestoDatasetId, bigQueryDatasetId);
        return dataset;
    }

    protected TableId createDestinationTable(TableId tableId) {
        String project = this.viewMaterializationProject.orElse(tableId.getProject());
        String dataset = this.viewMaterializationDataset.orElse(tableId.getDataset());
        DatasetId datasetId = this.mapIfNeeded(project, dataset);
        return TableId.of((String)datasetId.getProject(), (String)datasetId.getDataset(), (String)this.createTableName());
    }

    private String createTableName() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return this.caseSensitiveNameMatching ? String.format("%s%s", "_pbc_", uuid) : String.format("%s%s", "_pbc_", uuid).toLowerCase(Locale.ENGLISH);
    }

    private DatasetId mapIfNeeded(String project, String dataset) {
        DatasetId datasetId = DatasetId.of((String)project, (String)dataset);
        return this.datasetIds.getOrDefault(datasetId, datasetId);
    }

    protected Table update(TableInfo table) {
        return this.bigQuery.update(table, new BigQuery.TableOption[0]);
    }

    protected Job create(JobInfo jobInfo) {
        return this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
    }

    protected TableResult query(String sql) {
        try {
            return this.bigQuery.query(QueryJobConfiguration.of((String)sql), new BigQuery.JobOption[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BigQueryException(BigQueryErrorCode.BIGQUERY_QUERY_FAILED_UNKNOWN.toErrorCode().getCode(), String.format("Failed to run the query [%s]", sql), (Throwable)e);
        }
    }

    protected String createSql(TableId table, List<String> requiredColumns) {
        String columns = requiredColumns.isEmpty() ? "*" : requiredColumns.stream().map(column -> String.format("`%s`", column)).collect(Collectors.joining(","));
        return this.createFormatSql(table, columns, new String[0]);
    }

    protected String createFormatSql(TableId table, String requiredColumns, String[] filters) {
        String tableName = this.fullTableName(table);
        String whereClause = BigQueryClient.createWhereClause(filters).map(clause -> "WHERE " + clause).orElse("");
        return String.format("SELECT %s FROM `%s` %s", requiredColumns, tableName, whereClause);
    }

    private static Optional<String> createWhereClause(String[] filters) {
        if (filters == null || filters.length == 0) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)"", filters));
    }

    private String fullTableName(TableId tableId) {
        tableId = this.tableIds.getOrDefault(tableId, tableId);
        return String.format("%s.%s.%s", tableId.getProject(), tableId.getDataset(), tableId.getTable());
    }

    private static /* synthetic */ boolean lambda$listTables$2(Set allowedTypes, Table table) {
        return allowedTypes.contains(table.getDefinition().getType());
    }
}

