/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.google.cloud.bigquery.Field;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum BigQueryType {
    BOOLEAN((Type)BooleanType.BOOLEAN),
    BYTES((Type)VarbinaryType.VARBINARY),
    DATE((Type)DateType.DATE),
    DATETIME((Type)TimestampType.TIMESTAMP),
    FLOAT((Type)DoubleType.DOUBLE),
    GEOGRAPHY((Type)VarcharType.VARCHAR),
    INTEGER((Type)BigintType.BIGINT),
    NUMERIC((Type)DecimalType.createDecimalType((int)38, (int)9)),
    RECORD(null),
    STRING((Type)VarcharType.createUnboundedVarcharType()),
    TIME((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE),
    TIMESTAMP((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);

    private static final int[] NANO_FACTOR;
    private final Type nativeType;

    private BigQueryType(Type nativeType) {
        this.nativeType = nativeType;
    }

    static RowType.Field toRawTypeField(Map.Entry<String, Adaptor> entry) {
        return BigQueryType.toRawTypeField(entry.getKey(), entry.getValue());
    }

    static RowType.Field toRawTypeField(String name, Adaptor typeAdaptor) {
        Type prestoType = typeAdaptor.getPrestoType();
        return RowType.field((String)name, (Type)prestoType);
    }

    static LocalDateTime toLocalDateTime(String datetime) {
        int dotPosition = datetime.indexOf(46);
        if (dotPosition == -1) {
            return LocalDateTime.from(DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(datetime));
        }
        LocalDateTime result = LocalDateTime.from(DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(datetime.substring(0, dotPosition)));
        String nanosStr = datetime.substring(dotPosition + 1);
        int nanoOfSecond = Integer.parseInt(nanosStr) * NANO_FACTOR[nanosStr.length()];
        return result.withNano(nanoOfSecond);
    }

    static long toPrestoTimestamp(String datetime) {
        return BigQueryType.toLocalDateTime(datetime).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public Type getNativeType(Adaptor typeAdaptor) {
        if (this == RECORD) {
            Map<String, Adaptor> subTypes = typeAdaptor.getBigQuerySubTypes();
            Preconditions.checkArgument((!subTypes.isEmpty() ? 1 : 0) != 0, (Object)"a record or struct must have sub-fields");
            List fields = subTypes.entrySet().stream().map(BigQueryType::toRawTypeField).collect(Collectors.toList());
            return RowType.from(fields);
        }
        return this.nativeType;
    }

    static {
        NANO_FACTOR = new int[]{-1, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    }

    static interface Adaptor {
        public BigQueryType getBigQueryType();

        public Map<String, Adaptor> getBigQuerySubTypes();

        public Field.Mode getMode();

        default public Type getPrestoType() {
            Type rawType = this.getBigQueryType().getNativeType(this);
            return this.getMode() == Field.Mode.REPEATED ? new ArrayType(rawType) : rawType;
        }
    }
}

