/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.bigquery.BigQueryClient;
import com.facebook.presto.plugin.bigquery.BigQueryColumnHandle;
import com.facebook.presto.plugin.bigquery.BigQueryConfig;
import com.facebook.presto.plugin.bigquery.BigQueryErrorCode;
import com.facebook.presto.plugin.bigquery.BigQueryException;
import com.facebook.presto.plugin.bigquery.BigQueryTableHandle;
import com.facebook.presto.plugin.bigquery.BigQueryTableLayoutHandle;
import com.facebook.presto.plugin.bigquery.Conversions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class BigQueryMetadata
implements ConnectorMetadata {
    static final int NUMERIC_DATA_TYPE_PRECISION = 38;
    static final int NUMERIC_DATA_TYPE_SCALE = 9;
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final Logger log = Logger.get(BigQueryMetadata.class);
    private final BigQueryClient bigQueryClient;
    private final String projectId;

    @Inject
    public BigQueryMetadata(BigQueryClient bigQueryClient, BigQueryConfig config) {
        this.bigQueryClient = bigQueryClient;
        this.projectId = config.getProjectId().orElse(bigQueryClient.getProjectId());
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)Streams.stream(this.bigQueryClient.listDatasets(this.projectId)).map(dataset -> dataset.getDatasetId().getDataset()).filter(schemaName -> !schemaName.equalsIgnoreCase(INFORMATION_SCHEMA)).collect(ImmutableList.toImmutableList());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        log.debug("listTables(session=%s, schemaName=%s)", new Object[]{session, schemaName});
        return this.listTablesWithTypes(session, schemaName, TableDefinition.Type.TABLE);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        log.debug("listViews(session=%s, schemaName=%s)", new Object[]{session, schemaName});
        return this.listTablesWithTypes(session, schemaName, TableDefinition.Type.VIEW);
    }

    private List<SchemaTableName> listTablesWithTypes(ConnectorSession session, Optional<String> schemaName, TableDefinition.Type ... types) {
        if (schemaName.isPresent() && schemaName.get().equalsIgnoreCase(INFORMATION_SCHEMA)) {
            return ImmutableList.of();
        }
        Set schemaNames = (Set)schemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.listSchemaNames(session)));
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String datasetId : schemaNames) {
            for (Table table : this.bigQueryClient.listTables(DatasetId.of((String)this.projectId, (String)datasetId), types)) {
                tableNames.add((Object)new SchemaTableName(datasetId, table.getTableId().getTable()));
            }
        }
        return tableNames.build();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        log.debug("getTableHandle(session=%s, tableName=%s)", new Object[]{session, tableName});
        Optional<TableInfo> tableInfo = this.getBigQueryTable(tableName);
        if (tableInfo.isPresent()) {
            log.debug("Table [%s.%s] was not found", new Object[]{tableName.getSchemaName(), tableName.getTableName()});
            return null;
        }
        return BigQueryTableHandle.from(tableInfo.get());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        log.debug("getTableMetadata(session=%s, table=%s, constraint=%s, desiredColumns=%s)", new Object[]{session, table, constraint, desiredColumns});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)table;
        if (desiredColumns.isPresent()) {
            bigQueryTableHandle = bigQueryTableHandle.withProjectedColumns((List<ColumnHandle>)ImmutableList.copyOf((Collection)desiredColumns.get()));
        }
        BigQueryTableLayoutHandle bigQueryTableLayoutHandle = new BigQueryTableLayoutHandle(bigQueryTableHandle);
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(new ConnectorTableLayout((ConnectorTableLayoutHandle)bigQueryTableLayoutHandle), constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        log.debug("getTableMetadata(session=%s, layoutHandle=%s)", new Object[]{session, layoutHandle});
        BigQueryTableLayoutHandle bigQueryTableLayoutHandle = (BigQueryTableLayoutHandle)layoutHandle;
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)bigQueryTableLayoutHandle, Optional.empty(), bigQueryTableLayoutHandle.getTupleDomain(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    private Optional<TableInfo> getBigQueryTable(SchemaTableName tableName) {
        TableInfo tableInfo = this.bigQueryClient.getTable(TableId.of((String)this.projectId, (String)tableName.getSchemaName(), (String)tableName.getTableName()));
        return tableInfo == null ? Optional.of(tableInfo) : Optional.empty();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName schemaTableName) {
        ConnectorTableHandle table = this.getTableHandle(session, schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return this.getTableMetadata(session, table);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        log.debug("getTableMetadata(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        TableInfo table = this.bigQueryClient.getTable(((BigQueryTableHandle)tableHandle).getTableId());
        SchemaTableName schemaTableName = new SchemaTableName(table.getTableId().getDataset(), table.getTableId().getTable());
        Schema schema = table.getDefinition().getSchema();
        ImmutableList columns = schema == null ? ImmutableList.of() : (List)schema.getFields().stream().map(Conversions::toColumnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(schemaTableName, (List)columns);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        log.debug("getColumnHandles(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        TableInfo table = this.bigQueryClient.getTable(((BigQueryTableHandle)tableHandle).getTableId());
        Schema schema = table.getDefinition().getSchema();
        return schema == null ? ImmutableMap.of() : schema.getFields().stream().collect(Collectors.toMap(Field::getName, Conversions::toColumnHandle));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        log.debug("getColumnMetadata(session=%s, tableHandle=%s, columnHandle=%s)", new Object[]{session, columnHandle, columnHandle});
        return ((BigQueryColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        log.debug("listTableColumns(session=%s, prefix=%s)", new Object[]{session, prefix});
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (NotFoundException ex) {
                throw new BigQueryException(BigQueryErrorCode.BIGQUERY_TABLE_DISAPPEAR_DURING_LIST, "Table disappeared during listing operation", ex);
            }
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTableName() == null) {
            return this.listTables(session, Optional.ofNullable(prefix.getSchemaName()));
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        Optional<TableInfo> tableInfo = this.getBigQueryTable(tableName);
        return tableInfo.isPresent() ? ImmutableList.of() : ImmutableList.of((Object)tableName);
    }
}

